<?php

use App\Http\Controllers\Admin\PosController;
use Carbon\Carbon;
use App\Lib\Captcha;
use App\Notify\Notify;
use App\Lib\ClientInfo;
use App\Lib\CurlRequest;
use App\Lib\FileManager;
use App\Models\Exchange;
use App\Models\Frontend;
use App\Models\Language;
use App\Constants\Status;
use App\Models\Extension;
use Illuminate\Support\Str;
use App\Models\GeneralSetting;
use App\Lib\GoogleAuthenticator;
use App\Models\NotificationTemplate;
use Illuminate\Support\Facades\Cache;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\CurrencyController;
use App\Http\Controllers\Admin\ExchangeController;
use App\Http\Controllers\Admin\EmployeesController;
use App\Http\Controllers\Admin\ManageUsersController;
use App\Http\Controllers\Admin\SupportTicketController;

function systemDetails()
{
    $system['name'] = 'Website';
    $system['version'] = '3.2';
    $system['build_version'] = '5.1.6';

    return $system;
}

function slug($string)
{
    return Str::slug($string);
}

function verificationCode($length)
{
    if ($length == 0) {
        return 0;
    }

    $min = pow(10, $length - 1);
    $max = (int) ($min - 1).'9';

    return random_int($min, $max);
}

function getNumber($length = 8)
{
    $characters = '1234567890';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }

    return $randomString;
}

function activeTemplate($asset = false)
{
    $template = session('template') ?? gs('active_template');
    if ($asset) {
        return 'assets/templates/'.$template.'/';
    }

    return 'templates.'.$template.'.';
}

function activeTemplateName()
{
    $template = session('template') ?? gs('active_template');

    return $template;
}

function siteLogo($type = null)
{
    $name = $type ? "/logo_$type.png" : '/logo.png';

    return getImage(getFilePath('logoIcon').$name);
}
function siteFavicon()
{
    return getImage(getFilePath('logoIcon').'/favicon.png');
}

function loadReCaptcha()
{
    return Captcha::reCaptcha();
}

function loadCustomCaptcha($width = '100%', $height = 46, $bgColor = '#003')
{
    return Captcha::customCaptcha($width, $height, $bgColor);
}

function verifyCaptcha()
{
    return Captcha::verify();
}

function loadExtension($key)
{
    $extension = Extension::where('act', $key)->where('status', Status::ENABLE)->first();

    return $extension ? $extension->generateScript() : '';
}

function getTrx($length = 12)
{
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }

    return $randomString;
}

function getAmount($amount, $length = 2)
{
    $length = gs()->show_number_after_decimal;
    $amount = round($amount ?? 0, $length);

    return $amount + 0;
}

function showAmount($amount, $decimal = 2, $separate = true, $exceptZeros = false, $currencyFormat = true)
{
    $decimal = gs()->show_number_after_decimal;
    $separator = '';
    if ($separate) {
        $separator = ',';
    }
    $printAmount = number_format($amount, $decimal, '.', $separator);
    if ($exceptZeros) {
        $exp = explode('.', $printAmount);
        if ($exp[1] * 1 == 0) {
            $printAmount = $exp[0];
        } else {
            $printAmount = rtrim($printAmount, '0');
        }
    }
    if ($currencyFormat) {
        if (gs('currency_format') == Status::CUR_BOTH) {
            return gs('cur_sym').$printAmount.' '.__(gs('cur_text'));
        } elseif (gs('currency_format') == Status::CUR_TEXT) {
            return $printAmount.' '.__(gs('cur_text'));
        } else {
            return gs('cur_sym').$printAmount;
        }
    }

    return $printAmount;
}

function removeElement($array, $value)
{
    return array_diff($array, (is_array($value) ? $value : [$value]));
}

function cryptoQR($wallet)
{
    return "https://api.qrserver.com/v1/create-qr-code/?data=$wallet&size=300x300&ecc=m";
}

function keyToTitle($text)
{
    return ucfirst(preg_replace('/[^A-Za-z0-9 ]/', ' ', $text));
}

function titleToKey($text)
{
    return strtolower(str_replace(' ', '_', $text));
}

function strLimit($title = null, $length = 10)
{
    return Str::limit($title, $length);
}

function getIpInfo()
{
    $ipInfo = ClientInfo::ipInfo();

    return $ipInfo;
}

function osBrowser()
{
    $osBrowser = ClientInfo::osBrowser();

    return $osBrowser;
}

function getTemplates()
{
    //    $param['purchasecode'] = env("PURCHASECODE");
    //    $param['website']      = @$_SERVER['HTTP_HOST'] . @$_SERVER['REQUEST_URI'] . ' - ' . env("APP_URL");
    //    $url                   = VugiChugi::gttmp() . systemDetails()['name'];
    //    $response              = CurlRequest::curlPostContent($url, $param);
    //    if ($response) {
    //        return $response;
    //    } else {
    //        return null;
    //    }
}

function getPageSections($arr = false)
{
    $jsonUrl = resource_path('views/').str_replace('.', '/', activeTemplate()).'sections.json';
    $sections = json_decode(file_get_contents($jsonUrl));
    if ($arr) {
        $sections = json_decode(file_get_contents($jsonUrl), true);
        ksort($sections);
    }

    return $sections;
}

function getImage($image, $size = null)
{
    $clean = '';
    if (file_exists($image) && is_file($image)) {
        return asset($image).$clean;
    }
    if ($size) {
        return route('placeholder.image', $size);
    }

    return asset('assets/images/default.png');
}

function notify($user, $templateName, $shortCodes = null, $sendVia = null, $createLog = true, $pushImage = null)
{
    $globalShortCodes = [
        'site_name' => gs('site_name'),
        'site_currency' => gs('cur_text'),
        'currency_symbol' => gs('cur_sym'),
    ];

    if (gettype($user) == 'array') {
        $user = (object) $user;
    }

    $shortCodes = array_merge($shortCodes ?? [], $globalShortCodes);
    
    $template = NotificationTemplate::where('act', $templateName)->first(); 
    
    if($sendVia == null && $template){
        $sendVia = [];
        if($template->email_status){
            array_push($sendVia, 'email');
        }
        if($template->sms_status){
            array_push($sendVia, 'sms');
        }
        if($template->push_status){
            array_push($sendVia, 'push');
        }
    }

    $notify = new Notify($sendVia);
    $notify->templateName = $templateName;
    $notify->shortCodes = $shortCodes;
    $notify->user = $user;
    $notify->createLog = $createLog;
    $notify->pushImage = $pushImage;
    $notify->userColumn = isset($user->id) ? $user->getForeignKey() : 'user_id';
    if(env('APP_NOTIFY') == 'true'){
        $notify->send();
    }
}

function getPaginate($paginate = null)
{
    if (! $paginate) {
        $paginate = gs('paginate_number');
    }

    return $paginate;
}

function paginateLinks($data, $view = null)
{
    return $data->appends(request()->all())->links($view);
}

function menuActive($routeName, $type = null, $param = null)
{
    if ($type == 3) {
        $class = 'side-menu--open';
    } elseif ($type == 2) {
        $class = 'sidebar-submenu__open';
    } else {
        $class = 'active';
    }

    if (is_array($routeName)) {
        foreach ($routeName as $key => $value) {
            if (request()->routeIs($value)) {
                return $class;
            }

        }
    } elseif (request()->routeIs($routeName)) {
        if ($param) {
            if (gettype($param) == 'array') {
                $param = $param[0];
            }
            $routeParam = array_values(@request()->route()->parameters ?? []);
            if (strtolower(@$routeParam[0]) == strtolower($param)) {
                return $class;
            } else {
                return;
            }

        }

        return $class;
    }
}

function fileUploader($file, $location, $size = null, $old = null, $thumb = null, $filename = null)
{
    $fileManager = new FileManager($file);
    $fileManager->path = $location;
    $fileManager->size = $size;
    $fileManager->old = $old;
    $fileManager->thumb = $thumb;
    $fileManager->filename = $filename;
    $fileManager->upload();

    return $fileManager->filename;
}

function fileManager()
{
    return new FileManager;
}

function getFilePath($key)
{
    return fileManager()->$key()->path;
}

function getFileSize($key)
{
    return fileManager()->$key()->size;
}

function getFileExt($key)
{
    return fileManager()->$key()->extensions;
}

function diffForHumans($date)
{
    $lang = session()->get('lang');
    if (! $lang) {
        $lang = getDefaultLang();
    }
    Carbon::setlocale($lang);

    return Carbon::parse($date)->diffForHumans();
}

function showDateTime($date, $format = 'Y-m-d h:i A')
{
    if (! $date) {
        return '-';
    }
    $lang = session()->get('lang');
    if (! $lang) {
        $lang = getDefaultLang();
    }
    Carbon::setlocale($lang);

    return Carbon::parse($date)->translatedFormat($format);
}

function getDefaultLang()
{
    return Language::where('is_default', Status::YES)->first()->code ?? 'en';
}

function getContent($dataKeys, $singleQuery = false, $limit = null, $orderById = false)
{
    $templateName = activeTemplateName();
    if ($singleQuery) {
        $content = Frontend::where('tempname', $templateName)->where('data_keys', $dataKeys)->orderBy('id', 'desc')->first();
    } else {
        $article = Frontend::where('tempname', $templateName);
        $article->when($limit != null, function ($q) use ($limit) {
            return $q->limit($limit);
        });
        if ($orderById) {
            $content = $article->where('data_keys', $dataKeys)->orderBy('id')->get();
        } else {
            $content = $article->where('data_keys', $dataKeys)->orderBy('id', 'desc')->get();
        }
    }

    return $content;
}

function verifyG2fa($user, $code, $secret = null)
{
    $authenticator = new GoogleAuthenticator;
    if (! $secret) {
        $secret = $user->tsc;
    }
    $oneCode = $authenticator->getCode($secret);
    $userCode = $code;
    if ($oneCode == $userCode) {
        $user->tv = Status::YES;
        $user->save();

        return true;
    } else {
        return false;
    }
}

function urlPath($routeName, $routeParam = null)
{
    if ($routeParam == null) {
        $url = route($routeName);
    } else {
        $url = route($routeName, $routeParam);
    }
    $basePath = route('home');
    $path = str_replace($basePath, '', $url);

    return $path;
}

function showMobileNumber($number)
{
    $length = strlen($number);

    return substr_replace($number, '***', 2, $length - 4);
}

function showEmailAddress($email)
{
    $endPosition = strpos($email, '@') - 1;

    return substr_replace($email, '***', 1, $endPosition);
}

function getRealIP()
{
    $ip = $_SERVER['REMOTE_ADDR'];
    // Deep detect ip
    if (filter_var(@$_SERVER['HTTP_FORWARDED'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_FORWARDED'];
    }
    if (filter_var(@$_SERVER['HTTP_FORWARDED_FOR'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_FORWARDED_FOR'];
    }
    if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }
    if (filter_var(@$_SERVER['HTTP_X_REAL_IP'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_X_REAL_IP'];
    }
    if (filter_var(@$_SERVER['HTTP_CF_CONNECTING_IP'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    if ($ip == '::1') {
        $ip = '127.0.0.1';
    }

    return $ip;
}

function appendQuery($key, $value)
{
    return request()->fullUrlWithQuery([$key => $value]);
}

function dateSort($a, $b)
{
    return strtotime($a) - strtotime($b);
}

function dateSorting($arr)
{
    usort($arr, 'dateSort');

    return $arr;
}

function gs($key = null)
{
    $general = Cache::get('GeneralSetting');
    if (! $general) {
        $general = GeneralSetting::first();
        Cache::put('GeneralSetting', $general);
    }
    if ($key) {
        return @$general->$key;
    }

    return $general;
}

function isImage($string)
{
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif'];
    $fileExtension = pathinfo($string, PATHINFO_EXTENSION);
    if (in_array($fileExtension, $allowedExtensions)) {
        return true;
    } else {
        return false;
    }
}

function isHtml($string)
{
    if (preg_match('/<.*?>/', $string)) {
        return true;
    } else {
        return false;
    }
}

function convertToReadableSize($size)
{
    preg_match('/^(\d+)([KMG])$/', $size, $matches);
    $size = (int) $matches[1];
    $unit = $matches[2];

    if ($unit == 'G') {
        return $size.'GB';
    }

    if ($unit == 'M') {
        return $size.'MB';
    }

    if ($unit == 'K') {
        return $size.'KB';
    }

    return $size.$unit;
}

function frontendImage($sectionName, $image, $size = null, $seo = false)
{
    if ($seo) {
        return getImage('assets/images/frontend/'.$sectionName.'/seo/'.$image, $size);
    }

    return getImage('assets/images/frontend/'.$sectionName.'/'.$image, $size);
}

function formateScope($scope)
{
    return ucwords(str_replace('-', ' ', strtolower($scope) == 'list' ? 'All' : $scope));
}

function exchangeSessionData()
{
    $currencyExchanger = session()->get('exchange_data');
    session()->forget('exchange_data');
    $currencyExchanger->createOrUpdateExchange();

    return to_route('user.exchange.preview');
}

function svgColor($fileName)
{
    $svg = file_get_contents(getImage(activeTemplate(true).'images/svg/'.$fileName.'.svg'));
    $svg = str_replace('{{file_color}}', '#'.gs('base_color'), $svg);

    return $svg;
}

function buildResponse($remark, $status, $notify, $data = null)
{
    $response = [
        'remark' => $remark,
        'status' => $status,
    ];
    $message = [];
    if ($notify instanceof \Illuminate\Support\MessageBag) {
        $message['error'] = collect($notify)->map(function ($item) {
            return $item[0];
        })->values()->toArray();
    } else {
        $message = [$status => collect($notify)->map(function ($item) {
            if (is_string($item)) {
                return $item;
            }
            if (count($item) > 1) {
                return $item[1];
            }

            return $item[0];
        })->toArray()];
    }
    $response['message'] = $message;
    if ($data) {
        $response['data'] = $data;
    }

    return response()->json($response);
}
function responseSuccess($remark, $notify, $data = null)
{
    return buildResponse($remark, 'success', $notify, $data);
}
function responseError($remark, $notify, $data = null)
{
    return buildResponse($remark, 'error', $notify, $data);
}
function cutDecimals($number, $precision = 2) {
    $factor = pow(10, $precision);
    return floor($number * $factor) / $factor;
}
function setEnvValue($key, $value)
{
    $path = base_path('.env');

    if (file_exists($path)) {
        // Read file
        $env = file_get_contents($path);

        // Replace existing key if present
        if (strpos($env, $key.'=') !== false) {
            $env = preg_replace(
                "/^{$key}=.*/m",
                "{$key}={$value}",
                $env
            );
        } else {
            // Append if key not found
            $env .= "\n{$key}={$value}";
        }

        file_put_contents($path, $env);
    }
}
function checkPermission($menu_name){
    $user = auth()->guard('admin')->user();
    if($user->id == 1){
        return 1;
    }
    if($menu_name == "Dashboard"){
        return true;
    }
    if($menu_name == "Exchange List" && $user->can('View - Exchange Menu')){
        return true;
    }
    if($menu_name == "Currency" && $user->can('View - Currency')){
        return true;
    }
    if($menu_name == "Manage Users" && $user->can('View - Manage Users')){
        return true;
    }
    if($menu_name == "Manage Employees" && $user->can('View - Manage Employees')){
        return true;
    }
    if($menu_name == "Support Ticket" && $user->can('View - Support Ticket')){
        return true;
    }
    if($menu_name == "Report" && $user->can('View - Report')){
        return true;
    }
    if($menu_name == "POS" && $user->can('View - POS')){
        return true;
    }
    if($menu_name == "Subscribers" && $user->can('View - Subscribers')){
        return true;
    }
    if($menu_name == "IP Blocking" && $user->can('View - IP Blocking')){
        return true;
    }
    if($menu_name == "Customer Reviews" && $user->can('View - Customer Reviews')){
        return true;
    }
    if($menu_name == "System Setting" && $user->can('View - System Setting')){
        return true;
    }
    if($menu_name == "Extra" && $user->can('View - Extra')){
        return true;
    }
    if($menu_name == "Home Modal" && $user->can('View - Home Modal')){
        return true;
    }
    if($menu_name == "Exchange Emails" && $user->can('View - Exchange Emails')){
        return true;
    }
    if($menu_name == "Hidden Emails" && $user->can('View - Hidden Exchange Emails')){
        return true;
    }
    return false;
}
function checkPermissionForSubMenu($parent_manu, $scope){
    $user = auth()->guard('admin')->user();
    if($user->id == 1){
        return true;
    }
    if($parent_manu == 'Exchange List'){
        return ExchangeController::checkPermission($user,$scope);
    } 
    if($parent_manu == 'Currency'){
        return CurrencyController::checkPermission($user,$scope);
    }
    if($parent_manu == 'Manage Users'){
        return ManageUsersController::checkPermission($user,$scope);
    }
    if($parent_manu == 'Manage Employees'){
        return EmployeesController::checkPermission($user,$scope);
    }
    if($parent_manu == 'Support Ticket'){
        return SupportTicketController::checkPermission($user,$scope);
    }
    if($parent_manu == 'Report'){
        return ReportController::checkPermission($user,$scope);
    }
    if($parent_manu == 'POS'){
        return PosController::checkPermission($user,$scope);
    }
    if($parent_manu == 'Extra'){
        return checkSpecificPermission('View - Extra');
    }
    return false;
}
function checkSpecificPermission($ability){
    if(auth()->guard('admin')->user()->can($ability) || auth()->guard('admin')->user()->id == 1){
        return true;
    }
    return false;
}