<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('forward_emails', function (Blueprint $table) {
            $table->id();
            $table->string('from');
            $table->string('subject');
            $table->string('date');
            $table->text('body');
            $table->text('note')->nullable();
            $table->boolean('is_checked')->default(false);
            $table->unsignedBigInteger('checked_by')->nullable();
            $table->boolean('is_hidden')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('forward_emails');
    }
};
