<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ImapController;
use App\Http\Controllers\Admin\BlockController;
use App\Models\Currency;

Route::namespace('Auth')->group(function () {
    Route::middleware('admin.guest')->group(function () {
        Route::controller('LoginController')->group(function () {
            Route::get('/', 'showLoginForm')->name('login');
            Route::post('/', 'login')->name('login');
            Route::get('logout', 'logout')->middleware('admin')->withoutMiddleware('admin.guest')->name('logout');
        });

        // Admin Password Reset
        Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function () {
            Route::get('reset', 'showLinkRequestForm')->name('reset');
            Route::post('reset', 'sendResetCodeEmail');
            Route::get('code-verify', 'codeVerify')->name('code.verify');
            Route::post('verify-code', 'verifyCode')->name('verify.code');
        });

        Route::controller('ResetPasswordController')->group(function () {
            Route::get('password/reset/{token}', 'showResetForm')->name('password.reset.form');
            Route::post('password/reset/change', 'reset')->name('password.change');
        });
    });
});

Route::middleware('admin')->group(function () {
    Route::controller('AdminController')->group(function () {
        Route::get('dashboard', 'dashboard')->name('dashboard');
        Route::get('profile', 'profile')->name('profile');
        Route::post('profile', 'profileUpdate')->name('profile.update');
        Route::get('password', 'password')->name('password');
        Route::post('password', 'passwordUpdate')->name('password.update');

        // Notification
        Route::get('notifications', 'notifications')->name('notifications');
        Route::get('notification/read/{id}', 'notificationRead')->name('notification.read');
        Route::get('notifications/read-all', 'readAllNotification')->name('notifications.read.all');
        Route::post('notifications/delete-all', 'deleteAllNotification')->name('notifications.delete.all');
        Route::post('notifications/delete-single/{id}', 'deleteSingleNotification')->name('notifications.delete.single');

        // Report Bugs
        Route::get('request-report', 'requestReport')->name('request.report');
        Route::post('request-report', 'reportSubmit');

        Route::get('download-attachments/{file_hash}', 'downloadAttachment')->name('download.attachment');
    });

    // Users Manager
    Route::controller('ManageUsersController')->name('users.')->prefix('users')->group(function () {
        Route::get('/', 'allUsers')->name('all');
        Route::get('active', 'activeUsers')->name('active');
        Route::get('banned', 'bannedUsers')->name('banned');
        Route::get('email-verified', 'emailVerifiedUsers')->name('email.verified');
        Route::get('email-unverified', 'emailUnverifiedUsers')->name('email.unverified');
        Route::get('mobile-unverified', 'mobileUnverifiedUsers')->name('mobile.unverified');
        Route::get('kyc-unverified', 'kycUnverifiedUsers')->name('kyc.unverified');
        Route::get('kyc-pending', 'kycPendingUsers')->name('kyc.pending');
        Route::get('mobile-verified', 'mobileVerifiedUsers')->name('mobile.verified');
        Route::get('with-balance', 'usersWithBalance')->name('with.balance');

        Route::get('detail/{id}', 'detail')->name('detail');
        Route::get('kyc-data/{id}', 'kycDetails')->name('kyc.details');
        Route::post('kyc-approve/{id}', 'kycApprove')->name('kyc.approve');
        Route::post('kyc-reject/{id}', 'kycReject')->name('kyc.reject');
        Route::post('update/{id}', 'update')->name('update');
        Route::post('add-sub-balance/{id}', 'addSubBalance')->name('add.sub.balance');

        Route::get('send-notification/{id}', 'showNotificationSingleForm')->name('notification.single');
        Route::post('send-notification/{id}', 'sendNotificationSingle')->name('notification.single');
        Route::get('login/{id}', 'login')->name('login');
        Route::post('status/{id}', 'status')->name('status');

        Route::get('send-notification', 'showNotificationAllForm')->name('notification.all');
        Route::post('send-notification', 'sendNotificationAll')->name('notification.all.send');
        Route::post('send-single-notification', 'sendSingleNotification')->name('notification.single.send');
        Route::get('list', 'list')->name('list');
        Route::get('count-by-segment/{methodName}', 'countBySegment')->name('segment.count');
        Route::get('notification-log/{id}', 'notificationLog')->name('notification.log');

        Route::get('/advance_search_users', 'advance_search_users')->name('advance.search');
    });

    // Subscriber
    Route::controller('SubscriberController')->prefix('subscriber')->name('subscriber.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('send-email', 'sendEmailForm')->name('send.email');
        Route::post('remove/{id}', 'remove')->name('remove');
        Route::post('send-email', 'sendEmail')->name('send.email');
    });

    // Gateway
    Route::name('gateway.')->prefix('gateway')->group(function () {
        // Automatic Gateway
        Route::controller('AutomaticGatewayController')->prefix('automatic')->name('automatic.')->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('edit/{alias}', 'edit')->name('edit');
            Route::post('update/{code}', 'update')->name('update');
            Route::post('remove/{id}', 'remove')->name('remove');
            Route::post('status/{id}', 'status')->name('status');
        });
    });

    // WITHDRAW SYSTEM
    Route::name('withdraw.')->prefix('withdraw')->group(function () {
        Route::controller('WithdrawalController')->name('data.')->group(function () {
            Route::get('pending/{user_id?}', 'pending')->name('pending');
            Route::get('approved/{user_id?}', 'approved')->name('approved');
            Route::get('rejected/{user_id?}', 'rejected')->name('rejected');
            Route::get('details/{id}', 'details')->name('details');
            Route::get('all/{user_id?}', 'all')->name('all');
            Route::post('approve', 'approve')->name('approve');
            Route::post('reject', 'reject')->name('reject');
        });
    });

    // Report
    Route::controller('ReportController')->prefix('report')->name('report.')->group(function () {
        Route::get('transaction/{user_id?}', 'transaction')->name('transaction');
        Route::get('login/history', 'loginHistory')->name('login.history');
        Route::get('referral/commission', 'referralCommission')->name('referral.commission');
        Route::get('login/ipHistory/{ip}', 'loginIpHistory')->name('login.ipHistory');
        Route::get('notification/history', 'notificationHistory')->name('notification.history');
        Route::get('email/detail/{id}', 'emailDetails')->name('email.details');
        Route::get('exchange/dashboard', 'exchangeDashboard')->name('exchange.dashboard');
        // Route::get('exchange/report-dashboard',  'exchangeAllReportDashboard')->name('exchange.report.dashboard');

    });

    // Admin Support
    Route::controller('SupportTicketController')->prefix('ticket')->name('ticket.')->group(function () {
        Route::get('/', 'tickets')->name('index');
        Route::get('pending', 'pendingTicket')->name('pending');
        Route::get('closed', 'closedTicket')->name('closed');
        Route::get('answered', 'answeredTicket')->name('answered');
        Route::get('view/{id}', 'ticketReply')->name('view');
        Route::post('reply/{id}', 'replyTicket')->name('reply');
        Route::post('close/{id}', 'closeTicket')->name('close');
        Route::get('download/{attachment_id}', 'ticketDownload')->name('download');
        Route::post('delete/{id}', 'ticketDelete')->name('delete');
    });

    // Language Manager
    Route::controller('LanguageController')->prefix('language')->name('language.')->group(function () {
        Route::get('/', 'langManage')->name('manage');
        Route::post('/', 'langStore')->name('manage.store');
        Route::post('delete/{id}', 'langDelete')->name('manage.delete');
        Route::post('update/{id}', 'langUpdate')->name('manage.update');
        Route::get('edit/{id}', 'langEdit')->name('key');
        Route::post('import', 'langImport')->name('import.lang');
        Route::post('store/key/{id}', 'storeLanguageJson')->name('store.key');
        Route::post('delete/key/{id}', 'deleteLanguageJson')->name('delete.key');
        Route::post('update/key/{id}', 'updateLanguageJson')->name('update.key');
        Route::get('get-keys', 'getKeys')->name('get.key');
    });

    Route::controller('GeneralSettingController')->group(function () {
        Route::get('system-setting', 'systemSetting')->name('setting.system');

        // General Setting
        Route::get('general-setting', 'general')->name('setting.general');
        Route::post('general-setting', 'generalUpdate');

        Route::get('setting/social/credentials', 'socialiteCredentials')->name('setting.socialite.credentials');
        Route::post('setting/social/credentials/update/{key?}', 'updateSocialiteCredential')->name('setting.socialite.credentials.update');
        Route::post('setting/social/credentials/status/{key?}', 'updateSocialiteCredentialStatus')->name('setting.socialite.credentials.status.update');

        // configuration
        Route::get('setting/system-configuration', 'systemConfiguration')->name('setting.system.configuration');
        Route::post('setting/system-configuration', 'systemConfigurationSubmit');

        // Logo-Icon
        Route::get('setting/logo-icon', 'logoIcon')->name('setting.logo.icon');
        Route::post('setting/logo-icon', 'logoIconUpdate')->name('setting.logo.icon');

        // Custom CSS
        Route::get('custom-css', 'customCss')->name('setting.custom.css');
        Route::post('custom-css', 'customCssSubmit');

        Route::get('custom-raw-code', 'customCode')->name('setting.custom.code');
        Route::post('custom-raw-code', 'customCodeSubmit');

        // Custom Javascript
        // Route::get('custom-javascript', 'customJavascript')->name('setting.custom.javascript');
        // Route::post('custom-javascript', 'customJavascriptSubmit');

        // sitemap
        Route::get('sitemap', 'sitemap')->name('setting.sitemap');
        Route::post('sitemap', 'sitemapSubmit');

        // robots
        Route::get('robot', 'robot')->name('setting.robot');
        Route::post('robot', 'robotSubmit');

        // Cookie
        Route::get('cookie', 'cookie')->name('setting.cookie');
        Route::post('cookie', 'cookieSubmit');

        // maintenance_mode
        Route::get('maintenance-mode', 'maintenanceMode')->name('maintenance.mode');
        Route::post('maintenance-mode', 'maintenanceModeSubmit');

        // trustpilot settings
        Route::get('trustpilot/', 'trustPilot')->name('trustpilot.credentials');
        Route::post('trustpilot/widget', 'trustPilotInsert')->name('trustpilot.widget.submit');
    });

    // blocked ip settings
    Route::controller('BlockedIpController')->group(function () {
        Route::get('blocked-ip', 'blockedIpList')->name('blocked.ip');
        Route::post('blocked-ip/insert', 'blockedIpInsert')->name('blocked.ip.submit');
        Route::post('blocked-ip/unblock', 'blockedIpDelete')->name('blocked.ip.delete');
    });

    Route::controller('CronConfigurationController')->name('cron.')->prefix('cron')->group(function () {
        Route::get('index', 'cronJobs')->name('index');
        Route::post('store', 'cronJobStore')->name('store');
        Route::post('update', 'cronJobUpdate')->name('update');
        Route::post('delete/{id}', 'cronJobDelete')->name('delete');
        Route::get('schedule', 'schedule')->name('schedule');
        Route::post('schedule/store', 'scheduleStore')->name('schedule.store');
        Route::post('schedule/status/{id}', 'scheduleStatus')->name('schedule.status');
        Route::get('schedule/pause/{id}', 'schedulePause')->name('schedule.pause');
        Route::get('schedule/logs/{id}', 'scheduleLogs')->name('schedule.logs');
        Route::post('schedule/log/resolved/{id}', 'scheduleLogResolved')->name('schedule.log.resolved');
        Route::post('schedule/log/flush/{id}', 'logFlush')->name('log.flush');
    });

    // KYC setting
    Route::controller('KycController')->group(function () {
        Route::get('kyc-setting', 'setting')->name('kyc.setting');
        Route::post('kyc-setting', 'settingUpdate');
    });

    // Notification Setting
    Route::name('setting.notification.')->controller('NotificationController')->prefix('notification')->group(function () {
        // Template Setting
        Route::get('global/email', 'globalEmail')->name('global.email');
        Route::post('global/email/update', 'globalEmailUpdate')->name('global.email.update');

        Route::get('global/sms', 'globalSms')->name('global.sms');
        Route::post('global/sms/update', 'globalSmsUpdate')->name('global.sms.update');

        Route::get('global/push', 'globalPush')->name('global.push');
        Route::post('global/push/update', 'globalPushUpdate')->name('global.push.update');

        Route::get('templates', 'templates')->name('templates');
        Route::get('template/edit/{type}/{id}', 'templateEdit')->name('template.edit');
        Route::post('template/update/{type}/{id}', 'templateUpdate')->name('template.update');

        // Email Setting
        Route::get('email/setting', 'emailSetting')->name('email');
        Route::post('email/setting', 'emailSettingUpdate');
        Route::post('email/test', 'emailTest')->name('email.test');

        // SMS Setting
        Route::get('sms/setting', 'smsSetting')->name('sms');
        Route::post('sms/setting', 'smsSettingUpdate');
        Route::post('sms/test', 'smsTest')->name('sms.test');

        Route::get('notification/push/setting', 'pushSetting')->name('push');
        Route::post('notification/push/setting', 'pushSettingUpdate');
        Route::post('notification/push/setting/upload', 'pushSettingUpload')->name('push.upload');
        Route::get('notification/push/setting/download', 'pushSettingDownload')->name('push.download');
    });

    // Plugin
    Route::controller('ExtensionController')->prefix('extensions')->name('extensions.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('update/{id}', 'update')->name('update');
        Route::post('status/{id}', 'status')->name('status');
    });

    // System Information
    Route::controller('SystemController')->name('system.')->prefix('system')->group(function () {
        Route::get('info', 'systemInfo')->name('info');
        Route::get('server-info', 'systemServerInfo')->name('server.info');
        Route::get('optimize', 'optimize')->name('optimize');
        Route::get('optimize-clear', 'optimizeClear')->name('optimize.clear');
        Route::get('system-update', 'systemUpdate')->name('update');
        Route::post('system-update', 'systemUpdateProcess')->name('update.process');
        Route::get('system-update/log', 'systemUpdateLog')->name('update.log');
    });

    // SEO
    Route::get('seo', 'FrontendController@seoEdit')->name('seo');

    // Frontend
    Route::name('frontend.')->prefix('frontend')->group(function () {
        Route::controller('FrontendController')->group(function () {
            Route::get('index', 'index')->name('index');
            Route::get('templates', 'templates')->name('templates');
            Route::post('templates', 'templatesActive')->name('templates.active');
            Route::get('frontend-sections/{key?}', 'frontendSections')->name('sections');
            Route::post('frontend-content/{key}', 'frontendContent')->name('sections.content');
            Route::get('frontend-element/{key}/{id?}', 'frontendElement')->name('sections.element');
            Route::get('frontend-slug-check/{key}/{id?}', 'frontendElementSlugCheck')->name('sections.element.slug.check');
            Route::get('frontend-element-seo/{key}/{id}', 'frontendSeo')->name('sections.element.seo');
            Route::post('frontend-element-seo/{key}/{id}', 'frontendSeoUpdate');
            Route::post('remove/{id}', 'remove')->name('remove');
            Route::post('import-content/{key}', 'importContent')->name('import');
        });

        // Page Builder
        Route::controller('PageBuilderController')->group(function () {
            Route::get('manage-pages', 'managePages')->name('manage.pages');
            Route::get('manage-pages/check-slug/{id?}', 'checkSlug')->name('manage.pages.check.slug');
            Route::post('manage-pages', 'managePagesSave')->name('manage.pages.save');
            Route::post('manage-pages/update', 'managePagesUpdate')->name('manage.pages.update');
            Route::post('manage-pages/delete/{id}', 'managePagesDelete')->name('manage.pages.delete');
            Route::get('manage-section/{id}', 'manageSection')->name('manage.section');
            Route::post('manage-section/{id}', 'manageSectionUpdate')->name('manage.section.update');

            Route::get('manage-seo/{id}', 'manageSeo')->name('manage.pages.seo');
            Route::post('manage-seo/{id}', 'manageSeoStore');
        });
    });

    // currency
    Route::controller('CurrencyController')->prefix('currency')->name('currency.')->group(function () {
        Route::get('index', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('save/{id?}', 'save')->name('save');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::get('transaction-proof-form/{id}', 'transactionProofForm')->name('transaction.proof.form');
        Route::get('sending-form/{id}', 'sendingForm')->name('sending.form');
        Route::post('form-submit/{id}', 'formSubmit')->name('form.submit');
        Route::post('status/{id}', 'status')->name('status');
        Route::post('api-key/update', 'updateApiKey')->name('api.update');
        Route::post('import/conversion-rate', 'conversionRate')->name('import.conversion');
        Route::post('save-order', 'saveOrder')->name('saveOrder');
    });

    // --------------------------- User Block ---------------------------
    Route::controller('UserBlockListController')->prefix('block-user')->name('block.user.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('save/{id?}', 'save')->name('save');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::post('delete/{id}', 'delete')->name('delete');
    });

    // --------------------------- Manage Currency ---------------------------
    Route::controller('GpayCurrencyManagerController')->prefix('manage-currency')->name('manage.currency.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('/toggle-status', 'toggleStatus')->name('toggle.status');
        // Route::get('create', 'create')->name('create');
        // Route::post('save/{id?}', 'save')->name('save');
        // Route::get('edit/{id}', 'edit')->name('edit');
        // Route::post('delete/{id}', 'delete')->name('delete');
    });

    // --------------------------- Hidden Charge ---------------------------
    Route::controller('GpayHiddenChargeController')->prefix('hidden-charge')->name('hidden.charge.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::put('update/{id}', 'update')->name('update');
        Route::post('toggle-status', 'toggleStatus')->name('toggle.status');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    // --------------------------- Discount Charge ---------------------------
    Route::controller('GpayCurrencyDiscountChargeController')->prefix('discount-charge')->name('discount.charge.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::put('update/{id}', 'update')->name('update');
        Route::post('toggle-status', 'toggleStatus')->name('toggle.status');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    // --------------------------- Modal ---------------------------
    Route::controller('EpayHomePageModalController')->prefix('epay-modal')->name('epaymodal.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::put('update/{id}', 'update')->name('update');
        Route::post('toggle-status', 'toggleStatus')->name('toggle.status');
        Route::get('delete/{id}', 'delete')->name('delete');
    });

    // exchange
    Route::controller('ExchangeController')->prefix('exchange')->name('exchange.')->group(function () {
        Route::get('/advance_search_exchange', 'advance_search')->name('advance.search');

        Route::get('/{scope}', 'index')->name('list');
        Route::get('details/{id}', 'details')->name('details');
        Route::post('cancel/{id}', 'cancel')->name('cancel');
        Route::post('approve/{id}', 'approve')->name('approve');
        Route::post('hold/{id}', 'hold')->name('hold');
        Route::post('pending/{id}', 'pending')->name('pending');
        Route::post('processing/{id}', 'processing')->name('processing');
        Route::post('refund/{id}', 'refund')->name('refund');
        Route::get('download/{id}', 'download')->name('download');
        Route::post('export/exchanges', 'exportExchanges')->name('export');
        Route::post('exchanges-bulk-update', 'exchanges_bulk_update')->name('bulk.update');
    });

    // referral
    Route::controller('ReferralController')->group(function () {
        Route::get('referral', 'index')->name('referral');
        Route::post('referral', 'store')->name('referral.store');
        Route::get('status', 'status')->name('referral.status');
    });
    Route::resource('blocks', BlockController::class);

    // Review
    Route::controller('ReviewController')->prefix('review')->name('review.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('toggle-status', 'toggleStatus')->name('toggle.status');
    });

    // POS (PROFIT / LOSS)
    Route::controller('PosController')->prefix('pos')->name('pos.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/final-profit', 'getFinalProfit')->name('final_profit');
        Route::get('/daily-profit', 'getdailyProfit')->name('daily_profit');
    });
    Route::name('employees.')->controller('EmployeesController')->group(function () {

        Route::prefix('employees')->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('/create', 'create')->name('create');
            Route::post('/store', 'store')->name('store');
            Route::get('/edit/{user}', 'edit')->name('edit');
            Route::post('/update/{user}', 'store')->name('update');
            Route::post('/delete/{user}', 'delete')->name('delete');
            Route::post('/password/{user}', 'password')->name('password');
        });

        Route::prefix('roles')->name('roles.')->group(function () {
            Route::get('/', 'role_index')->name('index');
            Route::post('/store', 'role_store')->name('store');
            Route::get('/edit/{role}', 'role_edit')->name('edit');
            Route::post('/update/{role}', 'role_update')->name('update');
            Route::post('/delete/{role}', 'role_delete')->name('delete');
        });

        Route::prefix('permissions')->name('permissions.')->group(function () {
            Route::get('/', 'permission_index')->name('index');
            Route::post('/store', 'permission_store')->name('store');
            Route::post('/update/{permission}', 'permission_store')->name('update');
            Route::post('/delete/{permission}', 'permission_delete')->name('delete');
        });

    });
    Route::get('imap', [ImapController::class, 'imap_config'])->name('imap.edit');
    Route::post('imap', [ImapController::class, 'save_imap_config'])->name('imap.store');
    Route::name('forwardEmails.')->controller('ForwardEmailController')->group(function () {
        Route::get('forward-emails', 'index')->name('index');
        Route::get('forward-emails/{email}', 'show')->name('show');
        Route::post('forward-emails/{email}/check', 'check')->name('check');
        Route::post('forward-emails/{email}/uncheck', 'uncheck')->name('uncheck');

    });
    Route::name('hiddenForwardEmails.')->controller('HiddenForwardEmailController')->group(function () {
        Route::get('hidden-forward-emails', 'hidden_index')->name('index');
    });

    Route::get('currency_update', function () {
        $all_currency = Currency::all();
        foreach ($all_currency as $currency) {
            if (!$currency->currency_id) {
                $slug = Str::slug($currency->name, '_');
                $currency->currency_id = $slug;
                $currency->save();
            }
        }
    });
});
