<?php
    $kycContent = getContent('kyc_content.content', true);
?>
<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="notice"></div>
        <div class="row justify-content-center gy-4">
            <?php if($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason): ?>
                <div class="col-12">
                    <div class="alert alert--danger" role="alert">
                        <div class="alert__icon"><i class="fas fa-file-signature"></i></div>
                        <p class="alert__message m-0">
                            <span class="fw-bold"><?php echo app('translator')->get('KYC Documents Rejected'); ?></span><br>
                            <small>
                                <i>
                                    <?php echo e(__(@$kycContent->data_values->rejected_content)); ?>

                                    <a class="link-color" data-bs-toggle="modal" data-bs-target="#kycRejectionReason"
                                       href="javascript::void(0)">
                                        <?php echo app('translator')->get('Click here'); ?>
                                    </a>
                                    <?php echo app('translator')->get('to show the reason'); ?>.<br>
                                    <a class="link-color" href="<?php echo e(route('user.kyc.form')); ?>">
                                        <?php echo app('translator')->get('Click Here'); ?>
                                    </a>
                                    <?php echo app('translator')->get('to Re-submit Documents'); ?>.
                                </i>
                            </small>
                        </p>
                    </div>
                </div>
            <?php elseif($user->kv == Status::KYC_UNVERIFIED): ?>
                <div class="col-12">
                    <div class="alert alert--info" role="alert">
                        <div class="alert__icon"><i class="fas fa-file-signature"></i></div>
                        <p class="alert__message m-0">
                            <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Required'); ?></span><br>
                            <small>
                                <i>
                                    <?php echo e(__(@$kycContent->data_values->unverified_content)); ?>

                                    <a class="link-color" href="<?php echo e(route('user.kyc.form')); ?>">
                                        <?php echo app('translator')->get('Click here'); ?>
                                    </a>
                                </i>
                            </small>
                        </p>
                    </div>
                </div>
            <?php elseif($user->kv == Status::KYC_PENDING): ?>
                <div class="col-12">
                    <div class="alert alert--warning" role="alert">
                        <div class="alert__icon"><i class="fas fa-user-check"></i></div>
                        <p class="alert__message m-0">
                            <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Pending'); ?></span><br>
                            <small>
                                <i>
                                    <?php echo e(__(@$kycContent->data_values->pending_content)); ?>

                                    <a class="link-color" href="<?php echo e(route('user.kyc.data')); ?>">
                                        <?php echo app('translator')->get('Click here'); ?>
                                    </a>
                                    <?php echo app('translator')->get('to see your submitted information'); ?>
                                </i>
                            </small>
                        </p>
                    </div>
                </div>
            <?php endif; ?>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-sync"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Approved Exchange'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($exchange['approved']); ?></h4>
                        <a href="<?php echo e(route('user.exchange.list', 'approved')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-undo-alt"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Pending Exchange'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($exchange['pending']); ?></h4>
                        <a href="<?php echo e(route('user.exchange.list', 'pending')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-window-close"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Canceled Exchange'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($exchange['cancel']); ?></h4>
                        <a href="<?php echo e(route('user.exchange.list', 'canceled')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-sync-alt"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Refunded Exchange'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($exchange['refunded']); ?></h4>
                        <a href="<?php echo e(route('user.exchange.list', 'refunded')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-exchange-alt"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Total Exchange'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($exchange['total']); ?></h4>
                        <a href="<?php echo e(route('user.exchange.list', 'list')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"> <i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fa-solid fa-list-ul"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Transactions'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($totalTransaction); ?></h4>
                        <a href="<?php echo e(route('user.transactions')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"> <i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item h-100">
                    <div class="widget-item__icon"><i class="fas fa-voicemail"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Answer Ticket'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($tickets['answer']); ?></h4>
                        <a href="<?php echo e(route('ticket.index')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-reply"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get('Reply Ticket'); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e($tickets['reply']); ?></h4>
                        <a href="<?php echo e(route('ticket.index')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="widget-item">
                    <div class="widget-item__icon"><i class="fas fa-dollar-sign"></i></div>
                    <div class="widget-item__content">
                        <h5 class="widget-item__title"><?php echo app('translator')->get(auth()->user()->username."'s Balance"); ?></h5>
                        <h4 class="widget-item__amount "><?php echo e(showAmount($user->balance)); ?></h4>
                        <a href="<?php echo e(route('user.report.commission.log')); ?>" class="btn--simple">
                            <?php echo app('translator')->get('View All'); ?>
                            <span class="icon text--base"><i class="fas fa-angle-double-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-5">
                <h5 class="title mb-2"><?php echo app('translator')->get(auth()->user()->username."'s Latest Exchanges"); ?></h5>
                <div class="card custom--card">
                    <?php if(!$latestExchange->isEmpty()): ?>
                        <div class="card-body p-0">
                            <table class="table custom--table table-responsive--md">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Exchange ID'); ?></th>
                                        <th><?php echo app('translator')->get('Send'); ?></th>
                                        <th><?php echo app('translator')->get('Received'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                        <th><?php echo app('translator')->get('Date'); ?></th>
                                        <th><?php echo app('translator')->get('Status'); ?></th>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $latestExchange; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exchange): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(@$exchange->exchange_id); ?></td>
                                            <td>
                                                <span class="thumb">
                                                    <img class="table-currency-img"
                                                         src="<?php echo e(getImage(getFilePath('currency') . '/' . @$exchange->sendCurrency->image, getFileSize('currency'))); ?>">
                                                </span>
                                                <?php echo e($exchange->sendCurrency->name); ?>

                                            </td>
                                            <td>
                                                <span class="thumb">
                                                    <img src="<?php echo e(getImage(getFilePath('currency') . '/' . @$exchange->receivedCurrency->image, getFileSize('currency'))); ?>"
                                                         class="table-currency-img">
                                                </span>
                                                <?php echo e(__($exchange->receivedCurrency ? $exchange->receivedCurrency->name : '')); ?>

                                            </td>
                                            <td>
                                                <?php echo e(number_format($exchange->sending_amount + $exchange->sending_charge,  $exchange->sendCurrency->show_number_after_decimal)); ?>

                                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                                                <i class="la la-arrow-right text--base"></i>
                                                <?php echo e(number_format($exchange->receiving_amount - $exchange->receiving_charge, $exchange->receivedCurrency ? $exchange->receivedCurrency->show_number_after_decimal : 1)); ?>

                                                <?php echo e(__($exchange->receivedCurrency ? @$exchange->receivedCurrency->cur_sym : '')); ?>

                                            </td>
                                            <td>
                                                <span class="d-block"><?php echo e(showDateTime(@$exchange->created_at)); ?></span>
                                                <span
                                                      class="text--base"><?php echo e(diffForHumans(@$exchange->created_at)); ?></span>
                                            </td>
                                            <td> <?php echo $exchange->badgeData(); ?> </td>
                                            <td>

                                                <a href="<?php echo e(route('user.exchange.details', $exchange->exchange_id)); ?>"
                                                   class="btn btn--base-outline btn-sm" data-reason="<?php echo e($exchange->cancle_reason); ?>">
                                                    <i class="fa fa-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make($activeTemplate . 'partials.empty', [
                            'message' => 'No Latest Exchange Found!',
                        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>

    <?php if($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason): ?>
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <button type="button" class="btn-close m-0" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(__($user->kyc_rejection_reason)); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/user/dashboard.blade.php ENDPATH**/ ?>