<?php
    $contactContent = getContent('contact_us.content', true);
?>
<?php $__env->startSection('content'); ?>
    <section class="contact-section padding-top padding-bottom">
        <div class="container">
            <div class="contact-top">
                <div class="row gy-4 justify-content-center">
                    <div class="col-lg-4 col-md-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__icon">
                                <?php echo @$contactContent->data_values->email_icon; ?>
                            </div>
                            <div class="contact-item__content">
                                <h6 class="contact-item__title"><?php echo e(__(@$contactContent->data_values->email_title)); ?></h6>
                                <p class="contact-item__desc text-dark">
                                    <?php echo e(__(@$contactContent->data_values->email_subtitle)); ?>

                                </p>
                                <a href="mailto:<?php echo e(@$contactContent->data_values->email); ?>" class="text--base mt-2 fw-bold ">
                                    <?php echo e(@$contactContent->data_values->email); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__icon">
                                <?php echo @$contactContent->data_values->mobile_icon; ?>
                            </div>
                            <div class="contact-item__content">
                                <h6 class="contact-item__title"><?php echo e(__(@$contactContent->data_values->mobile_title)); ?></h6>
                                <p class="contact-item__desc text-dark">
                                    <?php echo e(__(@$contactContent->data_values->mobile_subtitle)); ?>

                                </p>
                                <a href="tel:<?php echo e(@$contactContent->data_values->mobile); ?>" class="text--base mt-2 fw-bold">
                                    <?php echo e(@$contactContent->data_values->mobile); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__icon">
                                <?php echo @$contactContent->data_values->address_icon; ?>
                            </div>
                            <div class="contact-item__content">
                                <h6 class="contact-item__title"><?php echo e(__(@$contactContent->data_values->address_title)); ?></h6>
                                <p class="contact-item__desc text-dark">
                                    <?php echo e(__(@$contactContent->data_values->address_subtitle)); ?></p>
                                <p class="text--base mt-2 fw-bold"><?php echo e(@$contactContent->data_values->address); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row gy-4 align-items-center ">
                <div class="col-lg-6 ">
                    <div class="account-form section-bg">
                        <div class="account-form__content mb-5">
                            <h2 class="account-form__title"><?php echo e(__(@$contactContent->data_values->heading)); ?></h2>
                            <p class="account-form__desc"><?php echo e(__(@$contactContent->data_values->subheading)); ?></p>
                        </div>
                        <form method="POST" class="verify-gcaptcha disableSubmission">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Your Name'); ?></label>
                                    <input name="name" class="form--control bg-white" type="text" value="<?php echo e(old('name', @$user->fullname)); ?>"
                                        <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?> required>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Email Address'); ?></label>
                                    <input name="email" type="text" class="form--control bg-white" value="<?php echo e(old('email', @$user->email)); ?>"
                                        <?php if($user): ?> readonly <?php endif; ?> required>
                                </div>
                                <div class="form-group col-sm-12">
                                    <label class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                                    <input name="subject" type="text" class="form--control bg-white" value="<?php echo e(old('subject')); ?>" required>
                                </div>
                                <div class="form-group col-sm-12">
                                    <label class="form-label"><?php echo app('translator')->get('Your Message'); ?></label>
                                    <textarea name="message" wrap="off" class="form--control bg-white" required><?php echo e(old('message')); ?></textarea>
                                </div>
                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                <div class="form-group col-sm-12">
                                    <button type="submit" class="btn btn--base"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="contact-thumb">
                        <img src="<?php echo e(frontendImage('contact_us', @$contactContent->data_values->image, '630x490')); ?>" alt="contact image">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if(@$sections->secs != null): ?>
        <?php $__currentLoopData = json_decode(@$sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $(".account-form").find('.mb-2').addClass('mb-3')
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/contact.blade.php ENDPATH**/ ?>