<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="site-path" content="<?php echo e('/'.APP_PUBLIC_FOLDER); ?>">
    <title><?php echo e(gs()->siteName($pageTitle ?? '')); ?></title>

    <link rel="shortcut icon" type="image/png" href="<?php echo e(siteFavicon()); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/bootstrap.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/vendor/bootstrap-toggle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/line-awesome.min.css')); ?>">

    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/app.css')); ?>">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>

    <?php echo $__env->yieldPushContent('style'); ?>
    <script>
        const site_path = document.querySelector('meta[name="site-path"]').getAttribute("content")? document.querySelector('meta[name="site-path"]').getAttribute("content"): '';
        const general_settings = <?php echo json_encode(gs(), 15, 512) ?>

        function updateQueryParam(key, value) {
            const url = new URL(window.location);
            url.searchParams.set(key, value);
            window.location = url.toString();
        }
        function toggleSort(e, column) {
            const url = new URL(window.location);
            const currentSort = url.searchParams.get('sort'); // e.g. "amount:asc"
            let nextSort = '';

            if (currentSort) {
                const [currentColumn, currentDirection] = currentSort.split(':');

                if (currentColumn === column) {
                    // Same column clicked → cycle direction
                    if (currentDirection === 'asc') {
                        nextSort = `${column}:desc`;
                    } else if (currentDirection === 'desc') {
                        // Remove the sort param
                        url.searchParams.delete('sort');
                        window.location = url.toString();
                        return;
                    }
                } else {
                    // Different column clicked → reset to asc
                    nextSort = `${column}:asc`;
                }
            } else {
                $element = e.currentTarget;
                nextSort = `${column}:asc`;
            }

            // Update URL
            url.searchParams.set('sort', nextSort);
            window.location = url.toString();
        }


        
        window.stopAlertNotificationBroadcast = "<?php echo e(route('api.stop_alert')); ?>";
        window.APP_PUBLIC_FOLDER = "<?php echo e(APP_PUBLIC_FOLDER); ?>";
        window.exchange_advance_search = "<?php echo e(route('admin.exchange.advance.search')); ?>";
        window.current_url = "<?php echo e(url()->current()); ?>"
    </script>
    <?php
        $customView = 'components.custom.custom';
    ?>

    <?php if(View::exists($customView)): ?>
        <?php if (isset($component)) { $__componentOriginal81e436eb51832a1616c9d03b799a6403 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal81e436eb51832a1616c9d03b799a6403 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.custom.custom','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('custom.custom'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal81e436eb51832a1616c9d03b799a6403)): ?>
<?php $attributes = $__attributesOriginal81e436eb51832a1616c9d03b799a6403; ?>
<?php unset($__attributesOriginal81e436eb51832a1616c9d03b799a6403); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal81e436eb51832a1616c9d03b799a6403)): ?>
<?php $component = $__componentOriginal81e436eb51832a1616c9d03b799a6403; ?>
<?php unset($__componentOriginal81e436eb51832a1616c9d03b799a6403); ?>
<?php endif; ?>
    <?php endif; ?>
</head>

<body>

    <?php echo $__env->yieldContent('content'); ?>

    <script src="<?php echo e(asset('assets/global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/bootstrap-toggle.min.js')); ?>"></script>


    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldPushContent('script-lib'); ?>

    <script src="<?php echo e(asset('assets/global/js/nicEdit.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/app.js')); ?>"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>

    
    <script>
        "use strict";

        bkLib.onDomLoaded(function() {
            $(".nicEdit").each(function(index) {
                $(this).attr("id", "nicEditor" + index);
                new nicEditor({
                    fullPanel: true
                }).panelInstance('nicEditor' + index, {
                    hasPanel: true
                });
            });
        });
        (function($) {
            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });
        })(jQuery);

        (function($) {


            $('.breadcrumb-nav-open').on('click', function() {
                $(this).toggleClass('active');
                $('.breadcrumb-nav').toggleClass('active');
            });

            $('.breadcrumb-nav-close').on('click', function() {
                $('.breadcrumb-nav').removeClass('active');
            });

            if ($('.topTap').length) {
                $('.breadcrumb-nav-open').removeClass('d-none');
            }
        })(jQuery);
    </script>

    <?php echo $__env->yieldPushContent('script'); ?>

</body>

</html>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/admin/layouts/master.blade.php ENDPATH**/ ?>