<?php
    $affiliationContent = getContent('affiliation.content', true);
    $affiliationElements = getContent('affiliation.element', false, null, true);
?>
<?php if(@$affiliationContent): ?>
    <section class="affiliate-section padding-bottom padding-top">
        <div class="container">
            <div class="row justify-content-center mb-30-none">
                <div class="col-xl-8">
                    <div class="section-header">
                        <h2 class="title"><?php echo e(__(@$affiliationContent->data_values->heading)); ?></h2>
                        <p><?php echo e(__(@$affiliationContent->data_values->subheading)); ?></p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center gy-4">
                <?php $__currentLoopData = @$affiliationElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $affiliationElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="<?php if($loop->odd && $loop->last): ?> col-lg-12 <?php else: ?> col-lg-6 <?php endif; ?>">
                        <div class="affiliate-item h-100">
                            <div class="affiliate-thumb">
                                <span class="cate"><?php echo app('translator')->get('LEVEL'); ?> <?php echo e(@$affiliationElement->data_values->level); ?></span>
                                <h6 class="title text-white"><?php echo e(@$affiliationElement->data_values->commission); ?>%</h6>
                            </div>
                            <div class="affiliate-content d-flex align-items-center flex-wrap">
                                <?php echo e(__(@$affiliationElement->data_values->description)); ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/sections/affiliation.blade.php ENDPATH**/ ?>