<?php if(gs('multi_language')): ?>
    <?php
        $language = App\Models\Language::all();
        $activeLanguage = App\Models\Language::where('code', session('lang'))->first();
    ?>
    <div class="custom--dropdown ms-2">
        <div class="custom--dropdown__selected dropdown-list__item">
            <div>
                <div class="thumb">
                    <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$activeLanguage->image, getFileSize('language'))); ?>"
                        alt="language image">
                </div>
            </div>
            <span class="text"><?php echo e(__(@$activeLanguage->name)); ?></span>
        </div>
        <ul class="dropdown-list">
            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(@$item->id != @$activeLanguage->id): ?>
                    <li class="dropdown-list__item langSel" data-value="<?php echo e($item->code); ?>">
                        <div>
                            <div class="thumb">
                                <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$item->image, getFileSize('language'))); ?>"
                                    alt="language image">
                            </div>
                        </div>
                        <span class="text"><?php echo e(@$item->name); ?></span>
                    </li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use stric";
        $(document).ready(function() {
            $('.custom--dropdown__selected').on('click', function() {
                $(this).parent().toggleClass('open');
            });

            $('.custom--dropdown > .dropdown-list > .dropdown-list__item').on('click', function() {
                $('.custom--dropdown > .dropdown-list > .dropdown-list__item').removeClass('selected');
                $(this).addClass('selected').parent().parent().removeClass('open').children(
                    '.custom--dropdown__selected').html($(this).html());
            });

            $(document).on('keyup', function(evt) {
                if ((evt.keyCode || evt.which) === 27) {
                    $('.custom--dropdown').removeClass('open');
                }
            });

            $(document).on('click', function(evt) {
                if ($(evt.target).closest(".custom--dropdown > .custom--dropdown__selected").length === 0) {
                    $('.custom--dropdown').removeClass('open');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/partials/language.blade.php ENDPATH**/ ?>