<?php $__env->startSection('content'); ?>
    <section class="blog-section padding-top padding-bottom">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <article>
                        <div class="post-item post-classic post-details">
                            <div class="post-thumb c-thumb w-100">
                                <img src="<?php echo e(frontendImage('blog', @$blog->data_values->blog_image, '820x440')); ?>" alt="blog image">
                            </div>
                            <div class="post-content">
                                <div class="meta-post">
                                    <div class="date text-muted">
                                        <i class="far fa-calendar-alt"></i>
                                        <?php echo e(@$blog->created_at->format('d M Y')); ?>

                                    </div>
                                </div>
                                <div class="blog-header">
                                    <h4 class="title mt-0"><?php echo e(__($blog->data_values->title)); ?></h4>
                                </div>
                                <div class="entry-content">
                                    <?php echo $blog->data_values->description; ?>
                                </div>
                                <?php echo $__env->make($activeTemplate . 'partials.share', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </article>
                    <div class="comment-area">
                        <div class="fb-comments" data-href="<?php echo e(route('blog.details', $blog->slug)); ?>" data-numposts="5"></div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="b-sidebar">
                        <div class="widget widget-category">
                            <h6 class="title text-start"><?php echo app('translator')->get('Recent Blogs'); ?></h6>
                            <div class="widget-body p-0">
                                <ul class="blog-sidebar-list">
                                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="blog-sidebar-item d-flex gap-3 mb-3 pb-3">
                                            <div>
                                                <img src="<?php echo e(frontendImage('blog', 'thumb_' . @$blog->data_values->blog_image, '410x220')); ?>"
                                                    class="blog-image-thumb" alt="blog image">
                                            </div>
                                            <div>
                                                <a class="p-0" href="<?php echo e(route('blog.details', @$blog->slug)); ?>">
                                                    <?php echo e(strLimit(@$blog->data_values->title, 50)); ?>

                                                </a>
                                                <small class="text-muted">
                                                    <i class="las la-calendar"></i>
                                                    <?php echo e(showDateTime($blog->created_at, 'M d, Y')); ?>

                                                </small>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('fbComment'); ?>
    <?php echo loadExtension('fb-comment') ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .blog-image-thumb {
            width: 70px;
            height: 60px;
            object-fit: cover;
            border-radius: 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/blog_details.blade.php ENDPATH**/ ?>