<?php $__env->startSection('panel'); ?>
    <div class="row gy-4 justify-content-center">
        <div class="col-xl-4 col-sm-12">
            <div class="card <?php echo e($userBlocked ? 'blocked-user' : ''); ?>">
                <div class="card-header">
                    <h5 class="card-title"><?php echo app('translator')->get('Sent by '.$exchange->user->username); ?></h5>
                    
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5><?php echo e(__(@$exchange->sendCurrency->name)); ?></h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Payment Method'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5><?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?></h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Received Currency'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5>
                                <?php echo e(number_format($exchange->sending_amount, @$exchange->sendCurrency->show_number_after_decimal)); ?>

                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Amount'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5 class="text--danger">
                                <?php echo e(number_format( 0, 4)); ?> <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Hidden Charge Percentage'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5 class="text--danger">
                                <?php echo e(number_format( 0, 4)); ?> <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Hidden Charge Fixed'); ?></small>
                        </li>

                        
                        <?php if(isset($charges['sell'])): ?>
                            <?php if(isset($charges['sell']['percent'])): ?>
                                <?php $__currentLoopData = $charges['sell']['percent']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $charge_amount =  (float)number_format(( ($charge['charge_percent'] / 100) * $exchange->sending_amount) ?? 0, $exchange->sendCurrency->show_number_after_decimal);
                                    ?>
                                    <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                        <h5 class="<?php echo e($charge_amount > 0? 'text--success': 'text--danger'); ?>">
                                            <?php echo e($charge_amount); ?> <?php echo e($exchange->sendCurrency->cur_sym); ?>

                                        </h5>
                                        <small class="text-muted"> <?php echo app('translator')->get($charge['title']); ?></small>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(isset($charges['sell']['fixed'])): ?>
                            <?php $__currentLoopData = $charges['sell']['fixed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $charge_amount =  (float)number_format($charge['charge_fixed'] ?? 0, $exchange->sendCurrency->show_number_after_decimal);
                                    ?>
                                    <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                        <h5 class="<?php echo e($charge_amount > 0? 'text--success': 'text--danger'); ?>">
                                            <?php echo e($charge_amount); ?> <?php echo e($exchange->sendCurrency->cur_sym); ?>

                                        </h5>
                                        <small class="text-muted"> <?php echo app('translator')->get($charge['title']); ?></small>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        <?php endif; ?>

                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5 class="<?php echo e($exchange->sending_charge > 0? 'text--success': 'text--danger'); ?>">
                                <?php echo e(number_format($exchange->sending_charge, @$exchange->sendCurrency->show_number_after_decimal)); ?>

                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Total Charge'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5>
                                <?php echo e(number_format($exchange->sending_charge + $exchange->sending_amount, @$exchange->sendCurrency->show_number_after_decimal)); ?>

                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Total Amount Sent By User'); ?></small>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-sm-12">
            <div class="card <?php echo e($userBlocked ? 'blocked-user' : ''); ?>">
                <div class="card-header">
                    <h5 class="card-title"><?php echo app('translator')->get('Receivable for '.$exchange->user->username); ?></h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5><?php echo e(__(@$exchange->receivedCurrency->name)); ?></h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Payment Method'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5><?php echo e(__($exchange->receivedCurrency->cur_sym)); ?></h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Currency'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5>
                                <?php echo e(number_format($exchange->receiving_amount, $exchange->receivedCurrency->show_number_after_decimal)); ?>

                                <?php echo e(__($exchange->receivedCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Amount'); ?></small>
                        </li>
                        <?php if($exchange->hidden_charge_percent != null): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                <h5 class="text--danger">
                                    <?php echo e(number_format(($exchange->hidden_charge_percent / 100) * $exchange->receiving_amount ?? 0, 4)); ?>

                                    <?php echo e(__($exchange->receivedCurrency->cur_sym)); ?>

                                </h5>
                                <small class="text-muted"> <?php echo app('translator')->get('Hidden Charge Percentage'); ?></small>
                            </li>
                        <?php endif; ?>
                        <?php if($exchange->hidden_charge_fixed != null): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                <h5 class="text--danger">
                                    <?php echo e(number_format($exchange->hidden_charge_fixed ?? 0, 4)); ?>

                                    <?php echo e(__($exchange->receivedCurrency->cur_sym)); ?>

                                </h5>
                                <small class="text-muted"> <?php echo app('translator')->get('Hidden Charge Fixed'); ?></small>
                            </li>
                        <?php endif; ?>
                        <?php if($exchange->hidden_charge_percent == null && $exchange->hidden_charge_fixed == null): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                <h5 class="text--danger">
                                    <?php echo e(number_format($exchange->hidden_charge_fixed ?? 0, 4)); ?>

                                    <?php echo e(__($exchange->receivedCurrency->cur_sym)); ?>

                                </h5>
                                <small class="text-muted"> <?php echo app('translator')->get('Hidden Percentage'); ?></small>
                            </li>
                            <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                <h5 class="text--danger">
                                    <?php echo e(number_format($exchange->hidden_charge_fixed ?? 0, 4)); ?>

                                    <?php echo e(__($exchange->receivedCurrency->cur_sym)); ?>

                                </h5>
                                <small class="text-muted"> <?php echo app('translator')->get('Hidden Fixed'); ?></small>
                            </li>
                        <?php endif; ?>


                        <!-- <?php if($exchange->sell_charge_fixed != null): ?>
                            <?php if($exchange->sell_charge_fixed < 0): ?>
                                <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                    <h5 class="text--danger">
                                        <?php echo e(number_format($exchange->sell_charge_fixed ?? 0, 4)); ?>

                                    </h5>
                                    <small class="text-muted"> <?php echo app('translator')->get('Discount'); ?></small>
                                </li>
                            <?php elseif($exchange->sell_charge_fixed > 0): ?>
                                <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                    <h5 class="text--danger">
                                        <?php echo e(number_format($exchange->sell_charge_fixed ?? 0, 4)); ?>

                                    </h5>
                                    <small class="text-muted"> <?php echo app('translator')->get('Discount'); ?></small>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?> -->
                        <?php if(isset($charges['buy'])): ?>
                            <?php if(isset($charges['buy']['percent'])): ?>
                                <?php $__currentLoopData = $charges['buy']['percent']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $charge_amount = isset($charge['charge_percent'])?((($charge['charge_percent'] / 100) * $exchange->receiving_amount) ?? 0): 0;
                                    ?>
                                    <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                        <h5 class="<?php echo e($charge_amount > 0? 'text--success': 'text--danger'); ?>">
                                            <?php echo e(number_format(-1 * $charge_amount, $exchange->receivedCurrency->show_number_after_decimal)); ?> <?php echo e($exchange->receivedCurrency->cur_sym); ?>

                                        </h5>
                                        <small class="text-muted"> <?php echo app('translator')->get($charge['title']?? ''); ?></small>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(isset($charges['buy']['fixed'])): ?>
                                <?php $__currentLoopData = $charges['buy']['fixed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $charge_amount =   ($charge['charge_fixed']) ?? 0;
                                    ?>
                                    <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                                        <h5 class="<?php echo e($charge_amount > 0? 'text--success': 'text--danger'); ?>">
                                            <?php echo e(number_format(-1 * $charge_amount, $exchange->receivedCurrency->show_number_after_decimal)); ?> <?php echo e($exchange->receivedCurrency->cur_sym); ?>

                                        </h5>
                                        <small class="text-muted"> <?php echo app('translator')->get($charge['title']); ?></small>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        <?php endif; ?>


                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5 class="<?php echo e($exchange->receiving_charge > 0? 'text--success': 'text--danger'); ?>">
                                <?php echo e(number_format(-1 * $exchange->receiving_charge, @$exchange->receivedCurrency->show_number_after_decimal)); ?>

                                <?php echo e(__(@$exchange->receivedCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Total Charge'); ?></small>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap flex-column">
                            <h5>
                                <?php echo e(number_format($exchange->receiving_amount - $exchange->receiving_charge, @$exchange->receivedCurrency->show_number_after_decimal)); ?>

                                <?php echo e(__(@$exchange->receivedCurrency->cur_sym)); ?>

                            </h5>
                            <small class="text-muted"> <?php echo app('translator')->get('Receivable Amount for User'); ?></small>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-8 col-sm-12">
            <?php if($exchange->user_data != null): ?>
                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-3 <?php echo e($userBlocked ? 'blocked-user' : ''); ?>">
                    <div class="card-header">
                        <h5><?php echo app('translator')->get('Sending Details'); ?></h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($component)) { $__componentOriginal42bc7a9986ac561a9c7747ba94199ece = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.view-form-data','data' => ['data' => $exchange->user_data]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('view-form-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($exchange->user_data)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $attributes = $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $component = $__componentOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="my-4"></div>
            <?php if($exchange->transaction_proof_data != null): ?>

                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-3 <?php echo e($userBlocked ? 'blocked-user' : ''); ?>">
                    <div class="card-header">
                        <h5><?php echo app('translator')->get('Transaction Proof'); ?></h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($component)) { $__componentOriginal42bc7a9986ac561a9c7747ba94199ece = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.view-form-data','data' => ['data' => $exchange->transaction_proof_data]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('view-form-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($exchange->transaction_proof_data)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $attributes = $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $component = $__componentOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
                    </div>
                </div>
                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-3 <?php echo e($userBlocked ? 'blocked-user' : ''); ?>">
                    <div class="card-header">
                        <h5><?php echo app('translator')->get('KYC Verification'); ?></h5>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $user_kyc_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="kyc-row">
                                <div><?php echo e($data->name); ?>: </div> <div class="kyc-value <?php echo e($data->value? "true": "false"); ?>"><?php echo e($data->value? "True" : "False"); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

            <?php endif; ?>
            <div class="my-4"></div>
            <div class="card <?php echo e($userBlocked ? 'blocked-user' : ''); ?>">
                <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
                    <h5 class="card-title"><?php echo app('translator')->get('Exchange Information'); ?></h5>
                    
                    <?php if(checkSpecificPermission('Update - Exchange')): ?>
                    <div class="d-flex flex-wrap justify-content-end mb-3 gap-2">
                        
                        <button class="btn btn-outline--warning btn-pending flex-grow-1" type="button" <?php if($exchange->is_locked): ?> disabled <?php endif; ?>>
                            <i class="fas fa-clock"></i>
                            <?php echo app('translator')->get('Pending'); ?>
                        </button>
                        <button class="btn btn-outline--success btn-hold flex-grow-1" type="button" <?php if($exchange->is_locked): ?> disabled <?php endif; ?>>
                            <i class="fas fa-undo"></i>
                            <?php echo app('translator')->get('Hold'); ?>
                        </button>
                        <button class="btn btn-outline--success btn-processing flex-grow-1" type="button" <?php if($exchange->is_locked): ?> disabled <?php endif; ?>>
                            <i class="fas fa-clock"></i>
                            <?php echo app('translator')->get('Processing'); ?>
                        </button>
                        
                        <button class="btn btn-outline--success btn-approved flex-grow-1" type="button" <?php if($exchange->is_locked): ?> disabled <?php endif; ?>>
                            <i class="fas fa-check"></i>
                            <?php echo app('translator')->get('Approve'); ?>
                        </button>
                        <button type="button" class="btn-outline--danger btn btn-cancel flex-grow-1" type="button" <?php if($exchange->is_locked): ?> disabled <?php endif; ?>>
                            <i class="fas fa-times"></i>
                            <?php echo app('translator')->get('Cancel'); ?>
                        </button>
                        <button type="button" class="btn btn-outline--warning btn-refund flex-grow-1" type="button" <?php if($exchange->is_locked): ?> disabled <?php endif; ?>>
                            <i class="fas fa-undo"></i>
                            <?php echo app('translator')->get('Refund'); ?>
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Exchange ID'); ?></span>
                            <span><strong><?php echo e($exchange->exchange_id); ?></strong></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('User Name'); ?></span>
                            <span>
                                <a class="text--primary" href="<?php echo e(route('admin.users.detail', $exchange->user_id)); ?>">
                                    <span class="text--primary">@</span><?php echo e(__(@$exchange->user->username)); ?>

                                </a>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Status'); ?></span>
                            <div class="text-end">
                                <?php echo $exchange->badgeData() ?>
                            </div>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Automatic Payment Status'); ?></span>
                            <div class="text-end">
                                <?php if($exchange->automatic_payment_status): ?>
                                    <span class="badge badge--success"><?php echo app('translator')->get('Completed'); ?></span>
                                <?php else: ?>
                                    <span class="badge badge--danger"><?php echo app('translator')->get('Not Completed'); ?></span>
                                <?php endif; ?>
                            </div>
                        </li>

                        <?php
                            $sell_rate_original = 0;
                            $buy_rate_original = 0;
                            $buy_rate_customer = 0;
                            $sell_rate_customer = 0;
                            if($exchange->transaction_type == "EXCHANGE"){
                                $buy_rate_original =  cutDecimals((1 / (float)$exchange->sell_rate) * (float)$exchange->buy_rate, $exchange->receivedCurrency->show_number_after_decimal);
                                $sell_rate_original = cutDecimals((1 / (float)$exchange->buy_rate) * (float)$exchange->sell_rate , $exchange->sendCurrency->show_number_after_decimal);
                                $buy_rate_customer =  cutDecimals(1 / (float)$exchange->customer_buying_rate, $exchange->receivedCurrency->show_number_after_decimal);
                                $sell_rate_customer = cutDecimals(1 / (float)$exchange->customer_selling_rate, $exchange->sendCurrency->show_number_after_decimal);
                            } else if($exchange->transaction_type == "DEPOSIT") {

                                $buy_rate_original = cutDecimals((float)$exchange->sendCurrency->buy_at, $exchange->receivedCurrency->show_number_after_decimal);
                                $sell_rate_original = cutDecimals(1 / (float)$exchange->sendCurrency->buy_at, $exchange->sendCurrency->show_number_after_decimal);
                                $buy_rate_customer = cutDecimals($exchange->buy_rate, $exchange->receivedCurrency->show_number_after_decimal);
                                $sell_rate_customer = cutDecimals(1 / (float)$exchange->buy_rate, $exchange->sendCurrency->show_number_after_decimal); 
                                
                            } else if($exchange->transaction_type == "WITHDRAW") {

                                $buy_rate_original = cutDecimals((float)$exchange->receivedCurrency->sell_at, $exchange->receivedCurrency->show_number_after_decimal);
                                $sell_rate_original = cutDecimals(1 / (float)$exchange->receivedCurrency->sell_at, $exchange->receivedCurrency->show_number_after_decimal);
                                $buy_rate_customer = cutDecimals($exchange->buy_rate, $exchange->sendCurrency->show_number_after_decimal);
                                $sell_rate_customer = cutDecimals(1 / (float)$exchange->buy_rate, $exchange->sendCurrency->show_number_after_decimal);
                            }
                            /*
                            $sell_rate_original = 0;
                            $buy_rate_original = 0;
                            if($exchange->transaction_type == "EXCHANGE"){
                                $buy_rate_original =  cutDecimals((1 / (float)$exchange->sell_rate) * (float)$exchange->buy_rate, 4);
                                $sell_rate_original = cutDecimals((1 / (float)$exchange->buy_rate) * (float)$exchange->sell_rate , 4);
                                $buy_rate_customer =  cutDecimals(1 / (float)$exchange->customer_buying_rate, 4);
                                $sell_rate_customer = cutDecimals(1 / (float)$exchange->customer_selling_rate, 4);
                            } else if($exchange->transaction_type == "DEPOSIT") {

                                $buy_rate_original = cutDecimals((float)$exchange->sendCurrency->buy_at, 4);
                                $sell_rate_original = cutDecimals(1 / (float)$exchange->sendCurrency->buy_at, 4);
                                $buy_rate_customer = cutDecimals($exchange->buy_rate, 4);
                                $sell_rate_customer = cutDecimals(1 / (float)$exchange->buy_rate, 4); 
                                
                            } else if($exchange->transaction_type == "WITHDRAW") {

                                $buy_rate_original = cutDecimals((float)$exchange->receivedCurrency->sell_at, 4);
                                $sell_rate_original = cutDecimals(1 / (float)$exchange->receivedCurrency->sell_at, 4);
                                $buy_rate_customer = cutDecimals($exchange->buy_rate, 4);
                                $sell_rate_customer = cutDecimals(1 / (float)$exchange->buy_rate, 4);
                            } */

                        ?>

                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Buy Rate'); ?></span>
                            <div>
                                <span>
                                    1 <?php echo e($exchange->sendCurrency->name); ?> <?php echo e($exchange->sendCurrency->cur_sym); ?>

                                    = <?php echo e($buy_rate_original); ?>

                                    <?php echo e($exchange->receivedCurrency->name); ?> <?php echo e($exchange->receivedCurrency->cur_sym); ?>

                                </span>
                            </div>
                        </li>

                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Sell Rate'); ?></span>
                            <div>
                                <span>
                                    1 <?php echo e($exchange->receivedCurrency->name); ?> <?php echo e($exchange->receivedCurrency->cur_sym); ?>

                                    = <?php echo e($sell_rate_original); ?>

                                    <?php echo e($exchange->sendCurrency->name); ?> <?php echo e($exchange->sendCurrency->cur_sym); ?>

                                </span>
                            </div>
                        </li>

                        
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Customer Buying Rate'); ?></span>
                            <div>
                                <span <?php if(number_format($buy_rate_original, 4) != number_format($buy_rate_customer,4)): ?> style="color: red;" <?php endif; ?>>
                                    1 <?php echo e($exchange->sendCurrency->name); ?> <?php echo e($exchange->sendCurrency->cur_sym); ?>

                                    = <?php echo e($buy_rate_customer); ?>

                                    <?php echo e($exchange->receivedCurrency->name); ?> <?php echo e($exchange->receivedCurrency->cur_sym); ?>

                                </span>
                            </div>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Customer Selling Rate'); ?></span>
                            <div>
                                <span <?php if(number_format($sell_rate_original, 4) != number_format($sell_rate_customer, 4)): ?> style="color: red;" <?php endif; ?>>
                                    1 <?php echo e($exchange->receivedCurrency->name); ?> <?php echo e($exchange->receivedCurrency->cur_sym); ?>

                                    = <?php echo e($sell_rate_customer); ?>

                                    <?php echo e($exchange->sendCurrency->name); ?> <?php echo e($exchange->sendCurrency->cur_sym); ?>

                                </span>
                            </div>
                        </li>

                        
                        <?php if($exchange->currency_discount > 0): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap border-dotted">
                                <div class="d-flex align-items-center gap-2">
                                    <span class="svg__icon">
                                        <i class="fas fa-percentage"></i>
                                    </span>
                                    <small class="fw-bold"><?php echo app('translator')->get('Discount'); ?></small>
                                </div>
                                <span class="fw-bold text--success">
                                    <?php echo e(number_format($exchange->currency_discount ?? 0, 4)); ?>%
                                </span>
                            </li>
                        <?php elseif($exchange->currency_charge > 0): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap border-dotted">
                                <div class="d-flex align-items-center gap-2">
                                    <span class="svg__icon">
                                        <i class="fas fa-coins"></i>
                                    </span>
                                    <small class="fw-bold"><?php echo app('translator')->get('Charge'); ?></small>
                                </div>
                                <span class="fw-bold text--danger">
                                    <?php echo e(number_format($exchange->currency_charge ?? 0, 4)); ?>%
                                </span>
                            </li>
                        <?php endif; ?>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Customer Wallet'); ?></span>
                            <span class="fw-bold"><?php echo e(__(@$exchange->wallet_id)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"> <?php echo app('translator')->get('Exchange Time'); ?></span>
                            <div class="text-end">
                                <span class="d-block"><?php echo e($exchange->created_at->format('d/m/y h:i:s A')); ?></span>
                                <span> <?php echo e(diffForHumans($exchange->created_at)); ?></span>
                            </div>
                        </li>
                        <?php if($exchangeLog->count()): ?>
                            <div class="card mt-4">
                                <div class="card-header">
                                    <h5 class="card-title"><?php echo app('translator')->get('Exchange Status Log'); ?></h5>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table--light">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('Status Changed'); ?></th>
                                                    <th><?php echo app('translator')->get('Updated By'); ?></th>
                                                    <th><?php echo app('translator')->get('Updated At'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $exchangeLog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($log->exchange_status); ?></td>
                                                        <td><?php echo e(@$log->adminUser->name ?? 'N/A'); ?></td>
                                                        <td><?php echo e(\Carbon\Carbon::parse($log->updated_date)->format('d M Y h:i A')); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if($exchange->admin_feedback): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span class="fw-bold">
                                    <?php if($exchange->status == Status::EXCHANGE_REFUND): ?>
                                        <?php echo app('translator')->get('Reason of refund'); ?>
                                    <?php elseif($exchange->status == Status::EXCHANGE_CANCEL): ?>
                                        <?php echo app('translator')->get('Reason of cancel'); ?>
                                    <?php endif; ?>
                                </span>
                                <span><?php echo e(__($exchange->admin_feedback)); ?></span>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <?php if($exchange->status == Status::EXCHANGE_APPROVED): ?>
                        <div class="form-group alert alert-success p-3">
                            <span class="fw-bold text-dark"><?php echo app('translator')->get('This exchange is paid successfully'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>


    <div id="modal" class="modal fade">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert!'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" class="disableSubmission">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e($exchange->id); ?>">
                    <div class="modal-body"></div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.exchange.list', 'list')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.exchange.list', 'list')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $attributes = $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $component = $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
    <?php if(!@$exchange->deposit): ?>
        <a href="<?php echo e(route('admin.exchange.download', $exchange->id)); ?>" class="btn btn-sm btn-outline--info">
            <i class="la la-download"></i><?php echo app('translator')->get('Download'); ?>
        </a>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            let modal = $('#modal');

            $('.btn-pending').on('click', function(e) {
                let html = `<p class="text-center"><?php echo app('translator')->get('Are you sure you want to put this exchange on Pending?'); ?></p>`;
                modal.find(".modal-body").html(html);
                modal.find('form').attr('action', `<?php echo e(route('admin.exchange.pending', $exchange->id)); ?>`);
                modal.find(".modal-title").text(`<?php echo app('translator')->get('Pending Exchange'); ?>`);
                modal.modal('show');
            });

            $('.btn-hold').on('click', function(e) {
                let html = `<p class="text-center"><?php echo app('translator')->get('Are you sure you want to put this exchange on hold?'); ?></p>`;
                modal.find(".modal-body").html(html);
                modal.find('form').attr('action', `<?php echo e(route('admin.exchange.hold', $exchange->id)); ?>`);
                modal.find(".modal-title").text(`<?php echo app('translator')->get('Hold Exchange'); ?>`);
                modal.modal('show');
            });

            $('.btn-processing').on('click', function(e) {
                let html = `<p class="text-center"><?php echo app('translator')->get('Are you sure you want to mark this exchange as processing?'); ?></p>`;
                modal.find(".modal-body").html(html);
                modal.find('form').attr('action', `<?php echo e(route('admin.exchange.processing', $exchange->id)); ?>`);
                modal.find(".modal-title").text(`<?php echo app('translator')->get('Processing Exchange'); ?>`);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            let modal = $('#modal');
            $('.btn-approved').on('click', function(e) {
                let html = `
        <div class="form-group">
            <label for="">Transaction Number</label>
            <input type="text" name="transaction" required class="form-control">
        </div>`;
                modal.find(".modal-body").html(html);
                modal.find('form').attr('action', `<?php echo e(route('admin.exchange.approve', $exchange->id)); ?>`)
                modal.find(".modal-title").text(`Approve Exchange`);
                modal.modal('show');
            });
            $('.btn-cancel').on('click', function(e) {
                let html = `
        <div class="form-group">
            <label>Reason Of Cancel</label>
            <textarea type="text" name="cancel_reason" required class="form-control"></textarea>
        </div>`;
                modal.find(".modal-body").html(html);
                modal.find('form').attr('action', `<?php echo e(route('admin.exchange.cancel', $exchange->id)); ?>`)
                modal.find(".modal-title").text(`Cancel Exchange`);
                modal.modal('show');
            });
            $('.btn-refund').on('click', function(e) {
                let html = `
        <div class="form-group">
            <label>Reason Of Refund</label>
            <textarea type="text" name="refund_reason" required class="form-control"></textarea>
        </div>`;
                modal.find('form').attr('action', `<?php echo e(route('admin.exchange.refund', $exchange->id)); ?>`)
                modal.find(".modal-body").html(html);
                modal.find(".modal-title").text(`Refund Exchange`);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .list-group-item {
            border: 1px solid rgba(140, 140, 140, 0.125)
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .list-group-item {
            border: 1px solid rgba(140, 140, 140, 0.125);
        }

        .blocked-user {
            border: 5px solid red !important;
        }
        .kyc-row{
            display: flex;
            gap: 20px;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .kyc-row .kyc-value{
            border-radius: 8px;
            width: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
        }
        .kyc-row .false{
            border: 1px solid red;
            color: red;
            padding: 5px;
        }
        .kyc-row .true{
            border: 1px solid green;
            color: green;
            padding: 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/admin/exchange/details.blade.php ENDPATH**/ ?>