<?php echo $__env->make($activeTemplate . 'partials.top_header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
    $footerContent = getContent('footer.content', true);
    $socialIcons = getContent('social_icons.element', false);
    $topCurrencies = App\Models\Exchange::where('status', Status::EXCHANGE_APPROVED)
        ->orWhere('automatic_payment_status', Status::YES)
        ->groupBy('send_currency_id')
        ->selectRaw('count(send_currency_id) as gateway , send_currency_id')
        ->take(3)
        ->with('sendCurrency:id,name,cur_sym')
        ->get();
    $policyPages = getContent('policy_pages.element', false, null, true);
?>

<footer class="overflow-hidden">
    <div class="footer-top padding-top padding-bottom">
        <div class="container">
            <div class="footer-area">
                <div class="footer-widget widget-about">
                    <div class="footer-logo">
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(siteLogo('dark')); ?>" alt="<?php echo e(gs('site_name')); ?>"
                                title="<?php echo e(__(gs('site_name'))); ?>">
                        </a>
                    </div>
                    <p><?php echo e(__(@$footerContent->data_values->details)); ?></p>
                </div>
                <div class="footer-widget widget-link">
                    <h5 class="title"><?php echo app('translator')->get('Support'); ?></h5>
                    <ul>
                        <li>
                            <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('pages', 'blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                        </li>
                        <?php if(auth()->guard()->guest()): ?>
                            <li>
                                <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                            </li>
                        <?php else: ?>
                            <li>
                                <a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="footer-widget widget-link">
                    <h5 class="title"><?php echo app('translator')->get('Exchange Gateways'); ?></h5>
                    <ul>
                        <?php $__currentLoopData = $topCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topCurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('home')); ?>">
                                    <?php echo e(__(@$topCurrency->sendCurrency->name)); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="footer-widget widget-link">
                    <h5 class="title"><?php echo app('translator')->get('Useful Link'); ?></h5>
                    <ul>
                        <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('policy.pages', $policy->slug)); ?>">
                                    <?php echo e(__($policy->data_values->title)); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom section-bg">
        <div class="container d-flex flex-wrap align-items-center justify-content-between">
            <p>
                <?php echo app('translator')->get('Copyright'); ?> &copy; <?php echo e(date('Y')); ?>

                <a class=" text--base" href="<?php echo e(route('home')); ?>"><?php echo e(__(gs('site_name'))); ?></a>.
                <span class="ms-1"><?php echo app('translator')->get('All Rights Reserved'); ?></span>
            </p>
            <ul class="social-icons">
                <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialIcon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li title="<?php echo e(ucfirst(@$socialIcon->data_values->title)); ?>">
                        <a href="<?php echo e(@$socialIcon->data_values->url); ?>"
                            class="<?php echo e(strtolower(@$socialIcon->data_values->name)); ?>" target="_blank">
                            <?php  echo @$socialIcon->data_values->icon; ?>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
</footer>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/partials/footer.blade.php ENDPATH**/ ?>