<?php
use Illuminate\Support\Str;
?>

<?php $__env->startSection('panel'); ?>
    <style>
        .table-container {
            overflow-x: auto;
            position: relative;
        }

        .data-table {
            border-collapse: collapse;
        }

        .data-table th,
        .data-table td {
            white-space: nowrap;
        }

        .sticky-col {
            position: sticky;
            right: 0;
            z-index: 2;
        }

        .data-table th {
            position: sticky;
            top: 0;
            z-index: 3;
        }
        .email-body{
            width: 100%;
            display: flex;
            justify-content: end;
        }
    </style>
    <?php
    $imap_config = json_decode(gs('imap_config'));
    ?>
    <div class="row pl-2 pb-2 ml-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <?php
                        $lastSegment = request()->segment(count(request()->segments()));
                    ?>
                    <form class="m-2" action="<?php echo e(route('admin.forwardEmails.index')); ?>" method="GET" autocomplete="off">
                        <?php if(request()->query('itemsPerPage')): ?>
                            <input type="hidden" name="itemsPerPage" value="<?php echo e(request('itemsPerPage')); ?>">
                        <?php endif; ?>
                        <div class="row pb-2">
                            <div class="col-lg-3 col-md-6 col-12 advance-search">
                                <label for="exchange_id">ID</label>
                                <input <?php if($request->id): ?> value="<?php echo e($request->id); ?>" <?php endif; ?> type="text" name="id"
                                    class="form-control" autocomplete="off">
                            </div>
                            <div class="col-lg-3 col-md-6 col-12 advance-search">
                                <label for="from">From</label>
                                <input <?php if($request->from): ?> value="<?php echo e($request->from); ?>" <?php endif; ?> type="text" name="from"
                                    class="form-control" autocomplete="off">
                            </div>
                            <div class="col-lg-3 col-md-6 col-12 advance-search">
                                <label for="subject">Subject</label>
                                <input <?php if($request->subject): ?> value="<?php echo e($request->subject); ?>" <?php endif; ?> type="text"
                                    name="subject" class="form-control" autocomplete="off">
                            </div>
                            <div class="col-lg-3 col-md-6 col-12 advance-search">
                                <label for="body">Body</label>
                                <input <?php if($request->body): ?> value="<?php echo e($request->body); ?>" <?php endif; ?> type="text" name="body"
                                    class="form-control" autocomplete="off">
                            </div>
                            <div class="col-lg-3 col-md-6 col-12" data-advance-search-url="">
                                <label for="received_from">Received From</label>
                                <input <?php if($request->received_from): ?> value="<?php echo e($request->received_from); ?>" <?php endif; ?> type="date"
                                    name="received_from" class="form-control">
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <label for="received_to">Received To</label>
                                <input <?php if($request->received_to): ?> value="<?php echo e($request->received_to); ?>" <?php endif; ?> type="date"
                                    name="received_to" class="form-control">
                            </div>
                        </div>
                        <button type="Submit" class="btn btn-sm btn-primary">Search</button>
                        <a href="<?php echo e(route('admin.forwardEmails.index')); ?>" class="btn btn-sm btn-info">Reset</a>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginaldc72b0ff2674646bf558af6dcee953a3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldc72b0ff2674646bf558af6dcee953a3 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.item-per-page','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('item-per-page'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldc72b0ff2674646bf558af6dcee953a3)): ?>
<?php $attributes = $__attributesOriginaldc72b0ff2674646bf558af6dcee953a3; ?>
<?php unset($__attributesOriginaldc72b0ff2674646bf558af6dcee953a3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldc72b0ff2674646bf558af6dcee953a3)): ?>
<?php $component = $__componentOriginaldc72b0ff2674646bf558af6dcee953a3; ?>
<?php unset($__componentOriginaldc72b0ff2674646bf558af6dcee953a3); ?>
<?php endif; ?>
    

    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                   
                    <div class="table-responsive--md  table-responsive table-container">
                        <table class="table table--light style--two data-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('ID'); ?></th>
                                    <th style="cursor: pointer;" onclick="toggleSort(event, 'created_at')">
                                        <div class="sortable-header">
                                            <span class="sort-indicate">
                                                <span class="up" <?php if(str_contains(request()->query("sort"), 'created_at')): ?>
                                                    style="visibility: <?php echo e(request()->query("sort") == "created_at:desc" ? "visible" : "hidden"); ?>;"
                                                <?php endif; ?>><i class="fa-solid fa-arrow-up"></i></span>
                                                <span class="down" <?php if(str_contains(request()->query("sort"), 'created_at')): ?>
                                                    style="visibility: <?php echo e(request()->query("sort") == "created_at:asc" ? "visible" : "hidden"); ?>;"
                                                <?php endif; ?>><i class="fa-solid fa-arrow-down"></i></span>
                                            </span>
                                            <span class="text">
                                                <?php echo app('translator')->get('Received Date Time'); ?>
                                            </span>
                                        </div>
                                    </th>
                                    <th><?php echo app('translator')->get('Send From'); ?></th>
                                    <th><?php echo app('translator')->get('Subject'); ?></th>
                                    <th><?php echo app('translator')->get('Body'); ?></th>
                                    <th><?php echo app('translator')->get('Note'); ?></th>
                                    <th><?php echo app('translator')->get('Checked By'); ?></th>
                                    <th><?php echo app('translator')->get('Checked At'); ?></th>
                                    <th class="sticky-col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    use App\Models\AdminUserModel;
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $emails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr style="background: <?php echo e($email->is_checked? 'rgb(171 255 189)': 'white'); ?>;">
                                        <td>
                                            <?php echo e($email->id); ?>

                                        </td>
                                        <td>
                                            <span class="fw-bold"><?php echo e($email->created_at->format('d/m/Y h:i:s A')); ?></span>
                                            <br>
                                        </td>
                                        <td>
                                            <?php echo e($email->from); ?>

                                        </td>
                                        <td><?php echo e($email->subject); ?></td>
                                        <td style="white-space: nowrap;">
                                            <div style="white-space: wrap;" class="email-body">
                                                <div style="width: 400px;">
                                                    <?php echo e(Str::limit($email->body, 400, '...')); ?>

                                                </div>
                                            </div>
                                        </td>
                                        <td style="width: 350px;"><?php echo e($email->note? $email->note: ($email->is_checked?"[No Note Found]":"[Not Checked Yet]")); ?></td>
                                        <td style="width: 350px;"><?php echo e($email->checked_by_admin? $email->checked_by_admin->name: "[Not Checked Yet]"); ?></td>
                                        <td style="width: 350px;"><?php echo e($email->checked_by_admin? $email->updated_at->format('d/m/Y h:i:s A'): "[Not Checked Yet]"); ?></td>
                                        <td class="sticky-col" style="background: <?php echo e($email->is_checked? 'rgb(171 255 189)': 'white'); ?>;">

                                            <?php if(
                                                $email->updated_at->gt(now()->subMinutes((int)$imap_config->timeout || 10)) || 
                                                !$email->is_checked ||
                                                auth('admin')->id() == 1
                                            ): ?>
                                            <?php if($email->is_checked): ?>
                                            <form action="<?php echo e(route('admin.forwardEmails.uncheck', $email->id)); ?>" style="display: inline" method="post">
                                                <?php echo csrf_field(); ?>
                                                <button class="btn btn-sm btn-outline--danger" <?php if(!checkSpecificPermission('Update - Exchange Emails')): ?> disabled <?php endif; ?>>
                                                    <i class="las la-minus"></i><?php echo app('translator')->get('Uncheck'); ?>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <button data-bs-toggle="modal" data-bs-target="#addNote_<?php echo e($email->id); ?>"
                                                class="btn btn-sm btn-outline--success" <?php if(!checkSpecificPermission('Update - Exchange Emails')): ?> disabled <?php endif; ?>>
                                                <i class="las la-check"></i><?php echo app('translator')->get('Check'); ?>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            
                                            <?php if(checkSpecificPermission('View - Exchange Emails Details')): ?>
                                                <a href="<?php echo e(route('admin.forwardEmails.show', $email->id)); ?>"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i><?php echo app('translator')->get('Details'); ?>
                                                </a>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-outline--primary" disabled>
                                                    <i class="las la-desktop"></i><?php echo app('translator')->get('Details'); ?>
                                                </button>
                                            <?php endif; ?>

                                        </td>
                                        <div id="addNote_<?php echo e($email->id); ?>" class="modal fade" tabindex="-1" role="dialog">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title"><span class="type"></span>
                                                                <span><?php echo app('translator')->get('Add Notes'); ?></span></h5>
                                                            <button type="button" class="close" data-bs-dismiss="modal"
                                                                aria-label="Close">
                                                                <i class="las la-times"></i>
                                                            </button>
                                                        </div>
                                                        <form action="<?php echo e(route('admin.forwardEmails.check', $email->id)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label><?php echo app('translator')->get('Notes'); ?></label>
                                                                    <div class="input-group">
                                                                        <textarea type="text" rows="10" name="note"
                                                                            class="form-control"
                                                                            placeholder="<?php echo app('translator')->get('You Can Enter a Note'); ?>"></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-muted text-center"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
                <?php if($emails->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($emails)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    
    <button type="button" class="btn  btn-outline--warning h-45 exportBtn">
        <i class="las la-cloud-download-alt"></i> <?php echo app('translator')->get('Export'); ?>
    </button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function toggleOrderBy() {
            let checkbox = document.getElementById('orderByCheckbox');
            let orderByInput = document.querySelector('input[name="order_by"]');
            orderByInput.value = checkbox.checked ? 'asc' : 'desc';
        }

        (function ($) {
            $('.exportBtn').on('click', function () {
                $('#exportModal').modal('show');
            });
            $('#select_all').click(e => {
                $('input[name="exchnage_id[]"]').prop('checked', e.target.checked);
            })
            $('#bulk_update_button').click(e => {
                e.preventDefault();
                const exchnage_type = $('#bulk_update_exchange_type').val();
                // collect only the checked checkboxes and map to values
                const ids = $('input[name="exchnage_id[]"]:checked').map(function () {
                    return $(this).val();
                }).get();

                if (!ids.length) {
                    alert('Please select at least one exchange to update.');
                    return;
                }

                const form = document.createElement('form');
                // set your bulk update endpoint here or leave empty and submit via AJAX
                form.action = "<?php echo e(route('admin.exchange.bulk.update')); ?>";
                form.method = 'POST';
                form.style.display = 'none';

                // CSRF token (Blade will render the token server-side)
                const csrfInput = document.createElement('input');
                csrfInput.type = 'hidden';
                csrfInput.name = '_token';
                csrfInput.value = '<?php echo e(csrf_token()); ?>';

                // Exchange action/type
                const exchnage_type_input = document.createElement('input');
                exchnage_type_input.type = 'hidden';
                exchnage_type_input.name = 'status';
                exchnage_type_input.value = exchnage_type;

                // Add one hidden input per selected id: ids[]
                ids.forEach(id => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'ids[]';
                    input.value = id;
                    form.appendChild(input);
                });

                // Append CSRF and action inputs then attach form to DOM (not submitted automatically)
                form.appendChild(csrfInput);
                form.appendChild(exchnage_type_input);
                document.body.appendChild(form);
                form.submit();
            })


            function syncSelects(changed, other) {
                let selected = $(changed).val() || [];

                $(other).find('option').each(function () {
                    let val = $(this).val();
                    if (selected.includes(val)) {
                        $(this).prop('disabled', true);
                    } else {
                        $(this).prop('disabled', false);
                    }
                });
                $(other).trigger('change.select2');
            }


            $('#send_currency_id').on('change', (e) => {
                syncSelects('#send_currency_id', '#receive_currency_id');
            })
            $('#receive_currency_id').on('change', (e) => {
                syncSelects('#receive_currency_id', '#send_currency_id');
            })
            syncSelects('#receive_currency_id', '#send_currency_id');
            syncSelects('#send_currency_id', '#receive_currency_id');
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/admin/exchange_emails/list.blade.php ENDPATH**/ ?>