<?php
    $blogContent = getContent('blog.content', true);
    $blogElements = getContent('blog.element', false, 3);
?>
<section class="blog-section padding-bottom padding-top">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-header">
                    <h2 class="title"><?php echo e(__(@$blogContent->data_values->heading)); ?></h2>
                    <p> <?php echo e(__(@$blogContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center gy-3">
            <?php $__currentLoopData = $blogElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-xl-4 col-sm-10">
                    <div class="post-item">
                        <div class="post-thumb c-thumb">
                            <a href="<?php echo e(route('blog.details', $blogElement->slug)); ?>">
                                <img class="w-100" src="<?php echo e(frontendImage('blog', 'thumb_' . @$blogElement->data_values->blog_image, '410x220')); ?>"
                                    alt="blog image">
                            </a>
                        </div>
                        <div class="post-content">
                            <div class="meta-post">
                                <div class="date blog-date">
                                    <span class="d-inline-block">
                                        <i class="far fa-calendar-alt text-muted"></i>
                                        <?php echo e(showDateTime($blogElement->created_at, 'M d, Y')); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="blog-header pt-0">
                                <h6 class="title">
                                    <a href="<?php echo e(route('blog.details', $blogElement->slug)); ?>">
                                        <?php echo e(__($blogElement->data_values->title)); ?>

                                    </a>
                                </h6>
                            </div>

                            <div class="entry-content">
                                <?php echo strLimit(strip_tags(@$blogElement->data_values->description), 120) ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/sections/blog.blade.php ENDPATH**/ ?>