<?php
    $latestExchangeContent = getContent('latest_exchange.content', true);
    $acceptedExchange = App\Models\Exchange::desc()->with('sendCurrency', 'receivedCurrency', 'user')->approved()->take(20)->get();
?>
<section class="section-bg padding-top padding-bottom">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-header">
                    <h2 class="title"><?php echo e(__(@$latestExchangeContent->data_values->heading)); ?></h2>
                    <p><?php echo e(__(@$latestExchangeContent->data_values->subheading)); ?> </p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card custom--card">
                    <?php if(!$acceptedExchange->isEmpty()): ?>
                        <div class="card-body p-0">
                            <table class="table custom--table table-responsive--md exchange-table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('User'); ?></th>
                                        <th><?php echo app('translator')->get('Sent'); ?></th>
                                        <th><?php echo app('translator')->get('Received'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                        <th><?php echo app('translator')->get('Date'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $acceptedExchange; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exchange): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(@$exchange->user->fullname); ?></td>
                                            <td>
                                                <span class="thumb">
                                                    <img class="table-currency-img"
                                                        src="<?php echo e(getImage(getFilePath('currency') . '/' . @$exchange->sendCurrency->image, getFileSize('currency'))); ?>"
                                                        alt="currency image">
                                                </span>
                                                <?php echo e($exchange->sendCurrency->name); ?>

                                            </td>
                                            <td>
                                                <span class="thumb">
                                                    <img src="<?php echo e(getImage(getFilePath('currency') . '/' . @$exchange->receivedCurrency->image, getFileSize('currency'))); ?>"
                                                        class="table-currency-img" alt="currency image">
                                                </span>
                                                <span>
                                                    <?php echo e(__($exchange->receivedCurrency ? $exchange->receivedCurrency->name : '')); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php echo e(showAmount((float) $exchange->sending_amount + (float) $exchange->sending_charge, currencyFormat: false)); ?>

                                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                                                <i class="la la-arrow-right" aria-hidden="true"></i>
                                                <?php echo e(showAmount((float) $exchange->receiving_amount - (float) $exchange->receiving_charge, currencyFormat: false)); ?>

                                                <?php echo e(__($exchange->receivedCurrency ? $exchange->receivedCurrency->cur_sym : '')); ?>

                                            </td>
                                            <td>
                                                <div>
                                                    <span class="d-block"><?php echo e(showDateTime($exchange->created_at)); ?></span>
                                                    <span><?php echo e(diffForHumans($exchange->created_at)); ?></span>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make($activeTemplate . 'partials.empty', [
                            'message' => 'No latest exchange found',
                        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/sections/latest_exchange.blade.php ENDPATH**/ ?>