<?php
    $faqContent = getContent('faq.content', true);
    $faqElements = getContent('faq.element');
?>
<?php if($faqContent): ?>
    <section class="faq-section padding-top padding-bottom">
        <div class="container">
            <div class="row">
                <div class="col-lg-5 d-lg-block d-none rtl">
                    <img src="<?php echo e(frontendImage('faq', @$faqContent->data_values->faq_image, '600x600')); ?>"
                        alt="faq image">
                </div>
                <div class="col-lg-7">
                    <div class="section-header left-style">
                        <h2 class="title"><?php echo e(__(@$faqContent->data_values->heading)); ?></h2>
                        <p><?php echo e(__(@$faqContent->data_values->subheading)); ?></p>
                    </div>
                    <div class="faq-wrapper mb--20">
                        <?php $__currentLoopData = $faqElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faqElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="faq-item <?php echo e($loop->first == 1 ? 'active open' : ''); ?>">
                                <div class="faq-title">
                                    <h6 class="title"><?php echo e(__(@$faqElement->data_values->question)); ?></h6>
                                    <span class="right-icon"></span>
                                </div>
                                <div class="faq-content"><?php echo e(__($faqElement->data_values->answer)); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/templates/blue_bliss/sections/faq.blade.php ENDPATH**/ ?>