<?php $__env->startSection('panel'); ?>
<style>
    .table-container {
        overflow-x: auto;
        position: relative;
    }

    .data-table {
        border-collapse: collapse;
    }

    .data-table th,
    .data-table td {
        white-space: nowrap;
    }

    .sticky-col {
        position: sticky;
        right: 0;
        z-index: 2;
    }
    .data-table th {
        position: sticky;
        top: 0;
        z-index: 3;
    }
</style>
    <div class="row pl-2 pb-2 ml-2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <?php
                    $lastSegment = request()->segment(count(request()->segments()));
                    ?>
                    <form class="m-2" action="<?php echo e(route('admin.exchange.list', $lastSegment)); ?>" method="GET" autocomplete="off">
                        <?php if(request()->query('itemsPerPage')): ?>
                            <input type="hidden" name="itemsPerPage" value="<?php echo e(request('itemsPerPage')); ?>">
                        <?php endif; ?>
                        <div class="row pb-2">
                            <div class="col-lg-3 col-md-6 col-12 advance-search" data-advance-search-url="<?php echo e(route('admin.exchange.advance.search')); ?>">
                                <label for="exchange_id">Exchange ID</label>
                                <input <?php if($request->exchange_id): ?> value="<?php echo e($request->exchange_id); ?>" <?php endif; ?> type="text" name="exchange_id" class="form-control" autocomplete="off">
                                <div class="suggestion-box">
                                    Input Search Text
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12 advance-search" data-advance-search-url="<?php echo e(route('admin.exchange.advance.search')); ?>">
                                <label for="email">Email / Username</label>
                                <input <?php if($request->email): ?> value="<?php echo e($request->email); ?>" <?php endif; ?> type="text" name="email" class="form-control" autocomplete="off">
                                <div class="suggestion-box">
                                    Input Search Text
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <label for="transaction_type">Transaction Type</label>
                                <select name="transaction_type[]" id="transaction_type" class="form-control select2" multiple="multiple">
                                    <option value="EXCHANGE" <?php if(is_array($request->transaction_type) && in_array('EXCHANGE',$request->transaction_type)): ?> selected <?php endif; ?>>EXCHANGE</option>
                                    <option value="DEPOSIT" <?php if(is_array($request->transaction_type) && in_array('DEPOSIT',$request->transaction_type)): ?> selected <?php endif; ?>>DEPOSIT</option>
                                    <option value="WITHDRAW" <?php if(is_array($request->transaction_type) && in_array('WITHDRAW',$request->transaction_type)): ?> selected <?php endif; ?>>WITHDRAW</option>
                                </select>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <?php
                                    $send_old = isset(request()->query()['send_currency_id'])? request()->query()['send_currency_id']: [];
                                ?>
                                <label for="send_currency_id">Send Method</label>
                                <select name="send_currency_id[]" id="send_currency_id" class="form-control select2" multiple="multiple">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($currency->id); ?>" <?php if(in_array($currency->id,$send_old )): echo 'selected'; endif; ?>><?php echo e($currency->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <?php
                                    $receive_old = isset(request()->query()['receive_currency_id'])? request()->query()['receive_currency_id']: [];
                                ?>
                                <label for="receive_currency_id">Receive Method</label>
                                <select name="receive_currency_id[]" id="receive_currency_id" class="form-control select2" multiple="multiple">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($currency->id); ?>" <?php if(in_array($currency->id,$receive_old )): echo 'selected'; endif; ?>><?php echo e($currency->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12" data-advance-search-url="">
                                <label for="created_from">Created From</label>
                                <input <?php if($request->created_from): ?> value="<?php echo e($request->created_from); ?>" <?php endif; ?> type="date" name="created_from" class="form-control">
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <label for="created_to">Created To</label>
                                <input <?php if($request->created_to): ?> value="<?php echo e($request->created_to); ?>" <?php endif; ?> type="date" name="created_to" class="form-control">
                            </div>
                        </div>
                        <button type="Submit" class="btn btn-sm btn-primary">Search</button>
                        <a href="<?php echo e(route('admin.exchange.list', $lastSegment)); ?>" class="btn btn-sm btn-info">Reset</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <?php if (isset($component)) { $__componentOriginaldc72b0ff2674646bf558af6dcee953a3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldc72b0ff2674646bf558af6dcee953a3 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.item-per-page','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('item-per-page'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldc72b0ff2674646bf558af6dcee953a3)): ?>
<?php $attributes = $__attributesOriginaldc72b0ff2674646bf558af6dcee953a3; ?>
<?php unset($__attributesOriginaldc72b0ff2674646bf558af6dcee953a3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldc72b0ff2674646bf558af6dcee953a3)): ?>
<?php $component = $__componentOriginaldc72b0ff2674646bf558af6dcee953a3; ?>
<?php unset($__componentOriginaldc72b0ff2674646bf558af6dcee953a3); ?>
<?php endif; ?>
    

    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive table-container">
                        <table class="table table--light style--two data-table">
                            <thead>
                                <tr>
                                    <?php if(auth()->id() == 1): ?> <th><input type="checkbox" name="" id="select_all" style="width: 25px; height: 25px; cursor: pointer;"></th><?php endif; ?>
                                    <th><?php echo app('translator')->get('Exchange ID'); ?></th>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Transaction Type'); ?></th>
                                    <th><?php echo app('translator')->get('Send Method'); ?></th>
                                    <th style="cursor: pointer;" onclick="toggleSort(event, 'sending_amount')"> 
                                        <div class="sortable-header">
                                            <span class="sort-indicate"> 
                                                <span class="up" <?php if(str_contains(request()->query("sort"),'sending_amount')): ?> style="visibility: <?php echo e(request()->query("sort") == "sending_amount:desc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-up"></i></span> 
                                                <span class="down" <?php if(str_contains(request()->query("sort"),'sending_amount')): ?> style="visibility: <?php echo e(request()->query("sort") == "sending_amount:asc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-down"></i></span> 
                                            </span> 
                                            <span class="text">
                                                <?php echo app('translator')->get('Send Amount'); ?>
                                            </span>
                                        </div>
                                    </th>
                                    <th><?php echo app('translator')->get('Received Method'); ?></th>
                                    <th style="cursor: pointer;" onclick="toggleSort(event, 'receiving_amount')">
                                        <div class="sortable-header">
                                            <span class="sort-indicate"> 
                                                <span class="up" <?php if(str_contains(request()->query("sort"),'receiving_amount')): ?> style="visibility: <?php echo e(request()->query("sort") == "receiving_amount:desc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-up"></i></span> 
                                                <span class="down" <?php if(str_contains(request()->query("sort"),'receiving_amount')): ?> style="visibility: <?php echo e(request()->query("sort") == "receiving_amount:asc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-down"></i></span> 
                                            </span> 
                                            <span class="text">
                                                <?php echo app('translator')->get('Received Amount'); ?>
                                            </span>
                                        </div>
                                    </th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th ><?php echo app('translator')->get('Updated By'); ?></th>
                                    <th ><?php echo app('translator')->get('Placed By'); ?></th>
                                    <th ><?php echo app('translator')->get('Aditional field / payment prove'); ?></th>
                                    <th style="cursor: pointer;" onclick="toggleSort(event, 'created_at')">
                                        <div class="sortable-header">
                                            <span class="sort-indicate"> 
                                                <span class="up" <?php if(str_contains(request()->query("sort"),'created_at')): ?> style="visibility: <?php echo e(request()->query("sort") == "created_at:desc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-up"></i></span> 
                                                <span class="down" <?php if(str_contains(request()->query("sort"),'created_at')): ?> style="visibility: <?php echo e(request()->query("sort") == "created_at:asc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-down"></i></span> 
                                            </span> 
                                            <span class="text">
                                                <?php echo app('translator')->get('Placed At'); ?>
                                            </span>
                                        </div>                                  
                                    </th>
                                    <th style="cursor: pointer;" onclick="toggleSort(event, 'updated_at')">
                                        <div class="sortable-header">
                                            <span class="sort-indicate"> 
                                                <span class="up" <?php if(str_contains(request()->query("sort"),'updated_at')): ?> style="visibility: <?php echo e(request()->query("sort") == "updated_at:desc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-up"></i></span> 
                                                <span class="down" <?php if(str_contains(request()->query("sort"),'updated_at')): ?> style="visibility: <?php echo e(request()->query("sort") == "updated_at:asc"? "visible": "hidden"); ?>;" <?php endif; ?>><i class="fa-solid fa-arrow-down"></i></span> 
                                            </span>
                                            <span class="text">
                                                <?php echo app('translator')->get('Updated At'); ?>
                                            </span>
                                        </div>
                                    </th>
                                    <th class="sticky-col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    use App\Models\AdminUserModel;
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $exchanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exchange): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <?php if(auth()->id() == 1): ?>
                                        <td>
                                            <input type="checkbox" name="exchnage_id[]" id="" style="width: 25px; height: 25px; cursor: pointer;" value="<?php echo e($exchange->id); ?>">
                                        </td>
                                        <?php endif; ?>
                                        <td>
                                            <span class="fw-bold"><?php echo e($exchange->exchange_id); ?></span>
                                            <br>
                                            <small class="text-muted"><?php echo e($exchange->created_at->format('d/m/y h:i:s A')); ?></small>
                                        </td>
                                        <td>
                                            <span class="d-block"><?php echo e(__(@$exchange->user->fullname)); ?></span>
                                            <span>
                                                <a class="text--primary"
                                                   href="<?php echo e(route('admin.users.detail', @$exchange->user_id)); ?>">
                                                    <span class="text--primary">@</span><?php echo e(__(@$exchange->user->username)); ?>

                                                </a>
                                            </span>
                                        </td>
                                        <td><?php echo e($exchange->transaction_type); ?></td>
                                        <td>
                                            <span class="d-block"><?php echo e(__(@$exchange->sendCurrency->name)); ?></span>
                                            <span class="text--primary"><?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block">
                                                <?php echo e(number_format($exchange->sending_amount, $exchange->sendCurrency->show_number_after_decimal)); ?>

                                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                                            </span>
                                            <span>
                                                <?php echo e(number_format($exchange->sending_amount, $exchange->sendCurrency->show_number_after_decimal)); ?>

                                            </span>
                                            <?php echo e($exchange->sending_charge >= 0? '+' : '-'); ?>

                                            <span class="text--danger">
                                                <?php echo e(number_format(abs($exchange->sending_charge), $exchange->sendCurrency->show_number_after_decimal)); ?>

                                            </span>
                                            =
                                            <span>
                                                <?php echo e(number_format($exchange->sending_amount + $exchange->sending_charge, $exchange->sendCurrency->show_number_after_decimal)); ?>

                                                <?php echo e(__(@$exchange->sendCurrency->cur_sym)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <span class="d-block"><?php echo e(__(@$exchange->receivedCurrency->name)); ?></span>
                                            <span class="text--primary"><?php echo e(__(@$exchange->receivedCurrency->cur_sym)); ?></span>
                                        </td>
                                        <td>
                                            <span class="d-block">
                                                <?php echo e(number_format($exchange->receiving_amount, $exchange->receivedCurrency ? $exchange->receivedCurrency->show_number_after_decimal : 2)); ?>

                                                <?php echo e(__(@$exchange->receivedCurrency->cur_sym)); ?>

                                            </span>
                                            <span>
                                                <?php echo e(number_format($exchange->receiving_amount, $exchange->receivedCurrency ? $exchange->receivedCurrency->show_number_after_decimal : 2)); ?>

                                            </span>
                                            <?php echo e($exchange->receiving_charge < 0? '+' : '-'); ?>

                                            <span class="text--danger">
                                                <?php echo e(number_format(abs($exchange->receiving_charge), $exchange->receivedCurrency ? $exchange->receivedCurrency->show_number_after_decimal : 2)); ?>

                                            </span>
                                            =
                                            <span>
                                                <?php echo e(number_format($exchange->receiving_amount - $exchange->receiving_charge, $exchange->receivedCurrency ? $exchange->receivedCurrency->show_number_after_decimal : 2)); ?>

                                                <?php echo e(__(@$exchange->receivedCurrency->cur_sym)); ?>

                                            </span>
                                        </td>
                                        <td> <?php echo $exchange->badgeData() ?> </td>
                                        <td> <?php echo e(@$exchange->updatedBy->name); ?> </td>
                                        <td> <?php echo e(isset($exchange->orderPlaceAdmin->name)? $exchange->orderPlaceAdmin->name: "User"); ?> </td>
                                        <td>
                                            
                                            <?php
                                                $transactionProof = is_string($exchange->transaction_proof_data)
                                                    ? json_decode($exchange->transaction_proof_data)
                                                    : $exchange->transaction_proof_data;
                                            
                                                $userData = is_string($exchange->user_data)
                                                    ? json_decode($exchange->user_data)
                                                    : $exchange->user_data;
                                            ?>
                                            
                                            <?php if($transactionProof): ?>
                                                <?php $__currentLoopData = $transactionProof; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($item->name ?? ''); ?>: <?php echo e($item->value ?? ''); ?><br>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            
                                            <?php if($userData): ?>
                                                <?php $__currentLoopData = $userData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($item->name ?? ''); ?>: <?php echo e($item->value ?? ''); ?><br>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </td>
                                        <td> <?php echo e($exchange->created_at->format('d/m/y h:i:s A')); ?> </td>
                                        <td> <?php echo e($exchange->updated_at->format('d/m/y h:i:s A')); ?> </td>
                                        <td class="sticky-col" style="background: white;">
                                            <?php if(checkSpecificPermission('View - Exchange')): ?>
                                            <a href="<?php echo e(route('admin.exchange.details', $exchange->id)); ?>"
                                               class="btn btn-sm btn-outline--primary">
                                                <i class="las la-desktop"></i><?php echo app('translator')->get('Details'); ?>
                                            </a>
                                            <?php else: ?>
                                            <button class="btn btn-sm btn-outline--primary" disabled>
                                                <i class="las la-desktop"></i><?php echo app('translator')->get('Details'); ?>
                                            </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-muted text-center"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if(auth()->id() == 1): ?>
                <div class="card-footer py-4" style="display: flex; place-items: center; gap: 5px;">
                    <select name="" id="bulk_update_exchange_type">
                        <option value=1>Approve</option>
                        <option value=2>Pending</option>
                        <option value=3>Refund</option>
                        <option value=4>Hold</option>
                        <option value=5>Proccessing</option>
                        <option value=9>Cancel</option>
                    </select>
                    <button class="btn btn-sm btn-primary" style="height: 36px;" id="bulk_update_button">Bulk Update</button>
                </div>
                <?php endif; ?>
                <?php if($exchanges->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($exchanges)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="exportModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('Export Filter'); ?></h4>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="la la-close" aria-hidden="true"></i>
                    </button>
                </div>
                <form method="post" action="<?php echo e(route('admin.exchange.export')); ?>" id="exportForm">
                    <?php echo csrf_field(); ?>
                    <?php $__currentLoopData = request()->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(is_array($value)): ?>
                            <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subKey => $subValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" name="<?php echo e($key); ?>[<?php echo e($subKey); ?>]" value="<?php echo e($subValue); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="modal-body">

                        <!-- Standard Export Columns -->
                        <div class="form-group">
                            <label class="fw-bold"><?php echo app('translator')->get('Export Columns'); ?></label>
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Exchange ID'); ?></label>
                                    <input type="checkbox" name="columns[]" value="exchange_id" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('User'); ?></label>
                                    <input type="checkbox" name="columns[]" value="user_id" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Transaction Type'); ?></label>
                                    <input type="checkbox" name="columns[]" value="transaction_type" checked
                                           data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Received Method'); ?></label>
                                    <input type="checkbox" name="columns[]" value="receive_currency_id" checked
                                           data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Received Amount'); ?></label>
                                    <input type="checkbox" name="columns[]" value="receiving_amount" checked
                                           data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Send Method'); ?></label>
                                    <input type="checkbox" name="columns[]" value="send_currency_id" checked
                                           data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Send Amount'); ?></label>
                                    <input type="checkbox" name="columns[]" value="sending_amount" checked
                                           data-width="100%" data-size="large" data-onstyle="-success"
                                           data-offstyle="-danger" data-bs-toggle="toggle" data-height="50"
                                           data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Status'); ?></label>
                                    <input type="checkbox" name="columns[]" value="status" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Placed By'); ?></label>
                                    <input type="checkbox" name="columns[]" value="placed_by" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Aditional field / payment prove'); ?></label>
                                    <input type="checkbox" name="columns[]" value="aditional_field_payment_prove" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Updated By'); ?></label>
                                    <input type="checkbox" name="columns[]" value="updated_by" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Placed At'); ?></label>
                                    <input type="checkbox" name="columns[]" value="placed_at" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label><?php echo app('translator')->get('Updated At'); ?></label>
                                    <input type="checkbox" name="columns[]" value="updated_at" checked data-width="100%"
                                           data-size="large" data-onstyle="-success" data-offstyle="-danger"
                                           data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>"
                                           data-off="<?php echo app('translator')->get('No'); ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Order By -->
                        <div class="form-group">
                            <label class="fw-bold"><?php echo app('translator')->get('Order By'); ?></label>
                            <input type="hidden" name="order_by" value="desc"> <!-- Default value -->
                            <input type="checkbox" id="orderByCheckbox" data-width="100%" data-size="large"
                                   data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50"
                                   data-on="<?php echo app('translator')->get('ASC'); ?>" data-off="<?php echo app('translator')->get('DESC'); ?>" onchange="toggleOrderBy()">
                        </div>

                        <!-- Export Item Selection -->
                        <div class="form-group">
                            <label class="fw-bold"><?php echo app('translator')->get('Export Item'); ?></label>
                            <select class="form-control form-control-lg" name="export_item">
                                <option value="10">10</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                                <option value="500">500</option>
                                <option value="1000">1000</option>
                                <option value="<?php echo e($exchanges->total()); ?>"><?php echo e($exchanges->total()); ?> <?php echo app('translator')->get('Exchanges'); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <input type="hidden" name="scope" value="<?php echo e($scope); ?>">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Export'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    
    <button type="button" class="btn  btn-outline--warning h-45 exportBtn">
        <i class="las la-cloud-download-alt"></i> <?php echo app('translator')->get('Export'); ?>
    </button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function toggleOrderBy() {
            let checkbox = document.getElementById('orderByCheckbox');
            let orderByInput = document.querySelector('input[name="order_by"]');
            orderByInput.value = checkbox.checked ? 'asc' : 'desc';
        }

        (function($) {
            $('.exportBtn').on('click', function() {
                $('#exportModal').modal('show');
            });
            $('#select_all').click(e => {
                $('input[name="exchnage_id[]"]').prop('checked', e.target.checked);
            })
            $('#bulk_update_button').click(e => {
                e.preventDefault();
                const exchnage_type = $('#bulk_update_exchange_type').val();
                // collect only the checked checkboxes and map to values
                const ids = $('input[name="exchnage_id[]"]:checked').map(function() {
                    return $(this).val();
                }).get();

                if (!ids.length) {
                    alert('Please select at least one exchange to update.');
                    return;
                }

                const form = document.createElement('form');
                // set your bulk update endpoint here or leave empty and submit via AJAX
                form.action = "<?php echo e(route('admin.exchange.bulk.update')); ?>";
                form.method = 'POST';
                form.style.display = 'none';

                // CSRF token (Blade will render the token server-side)
                const csrfInput = document.createElement('input');
                csrfInput.type = 'hidden';
                csrfInput.name = '_token';
                csrfInput.value = '<?php echo e(csrf_token()); ?>';

                // Exchange action/type
                const exchnage_type_input = document.createElement('input');
                exchnage_type_input.type = 'hidden';
                exchnage_type_input.name = 'status';
                exchnage_type_input.value = exchnage_type;

                // Add one hidden input per selected id: ids[]
                ids.forEach(id => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'ids[]';
                    input.value = id;
                    form.appendChild(input);
                });

                // Append CSRF and action inputs then attach form to DOM (not submitted automatically)
                form.appendChild(csrfInput);
                form.appendChild(exchnage_type_input);
                document.body.appendChild(form);
                form.submit();
            })


            function syncSelects(changed, other) {
                let selected = $(changed).val() || [];

                $(other).find('option').each(function() {
                    let val = $(this).val();
                    if (selected.includes(val)) {
                        $(this).prop('disabled', true);
                    } else {
                        $(this).prop('disabled', false);
                    }
                });
                $(other).trigger('change.select2');
            }


            $('#send_currency_id').on('change',(e) => {
                syncSelects('#send_currency_id', '#receive_currency_id');
            })
            $('#receive_currency_id').on('change',(e) => {
                syncSelects('#receive_currency_id', '#send_currency_id');
            })
            syncSelects('#receive_currency_id', '#send_currency_id');
            syncSelects('#send_currency_id', '#receive_currency_id');
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/gpay10.com/new/core/resources/views/admin/exchange/list.blade.php ENDPATH**/ ?>